/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RankFeatureFieldMapper
extends FieldMapper {
    public static final String NAME = "_feature";
    public static final String CONTENT_TYPE = "rank_feature";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean positiveScoreImpact;
    private final Float nullValue;

    private static RankFeatureFieldType ft(FieldMapper in) {
        return ((RankFeatureFieldMapper)in).fieldType();
    }

    private RankFeatureFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean positiveScoreImpact, Float nullValue) {
        super(simpleName, mappedFieldType, builderParams);
        this.positiveScoreImpact = positiveScoreImpact;
        this.nullValue = nullValue;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    public RankFeatureFieldType fieldType() {
        return (RankFeatureFieldType)super.fieldType();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        float value;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return;
            }
            value = this.nullValue.floatValue();
        } else {
            value = context.parser().floatValue();
        }
        if (context.doc().getByKey((Object)this.fullPath()) != null) {
            throw new IllegalArgumentException("[rank_feature] fields do not support indexing multiple values for the same field [" + this.fullPath() + "] in the same document");
        }
        if (!this.positiveScoreImpact) {
            value = 1.0f / value;
        }
        context.doc().addWithKey((Object)this.fullPath(), (IndexableField)new FeatureField(NAME, this.fullPath(), value));
    }

    private static Float objectToFloat(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    public static final class RankFeatureFieldType
    extends MappedFieldType {
        private final boolean positiveScoreImpact;
        private final Float nullValue;

        public RankFeatureFieldType(String name, Map<String, String> meta, boolean positiveScoreImpact, Float nullValue) {
            super(name, IndexType.terms((boolean)true, (boolean)false), false, meta);
            this.positiveScoreImpact = positiveScoreImpact;
            this.nullValue = nullValue;
        }

        public String typeName() {
            return RankFeatureFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public Query existsQuery(SearchExecutionContext context) {
            return new TermQuery(new Term(RankFeatureFieldMapper.NAME, this.name()));
        }

        public boolean fieldHasValue(FieldInfos fieldInfos) {
            return fieldInfos.fieldInfo(RankFeatureFieldMapper.NAME) != null;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[rank_feature] fields do not support sorting, scripting or aggregating");
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.sourceValueFetcher(context);
        }

        private SourceValueFetcher sourceValueFetcher(SearchExecutionContext context) {
            Set sourcePaths = context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet();
            return new SourceValueFetcher(this, sourcePaths, this.nullValue, context.getIndexSettings().getIgnoredSourceFormat()){

                protected Object parseSourceValue(Object value) {
                    return RankFeatureFieldMapper.objectToFloat(value);
                }
            };
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Queries on [rank_feature] fields are not supported");
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> positiveScoreImpact = FieldMapper.Parameter.boolParam((String)"positive_score_impact", (boolean)false, m -> RankFeatureFieldMapper.ft((FieldMapper)m).positiveScoreImpact, (boolean)true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Float> nullValue = new FieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> o == null ? null : RankFeatureFieldMapper.objectToFloat(o), m -> RankFeatureFieldMapper.ft((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).addValidator(value -> {
            if (value != null && value.floatValue() < Float.MIN_NORMAL) {
                throw new IllegalArgumentException("[null_value] must be a positive normal float for field of type [rank_feature], got " + value + " which is less than the minimum positive normal float: 1.1754944E-38");
            }
        }).acceptsNull();

        public Builder(String name) {
            super(name);
        }

        Builder nullValue(float nullValue) {
            this.nullValue.setValue((Object)Float.valueOf(nullValue));
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.positiveScoreImpact, this.nullValue, this.meta};
        }

        public RankFeatureFieldMapper build(MapperBuilderContext context) {
            return new RankFeatureFieldMapper(this.leafName(), new RankFeatureFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue(), (Boolean)this.positiveScoreImpact.getValue(), (Float)this.nullValue.getValue()), this.builderParams((Mapper.Builder)this, context), (Boolean)this.positiveScoreImpact.getValue(), (Float)this.nullValue.getValue());
        }
    }
}

