/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.errorquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndexError
implements Writeable,
ToXContentFragment {
    private final String indexName;
    private final int[] shardIds;
    private final ERROR_TYPE errorType;
    private final String message;
    private final int stallTimeSeconds;
    static final ConstructingObjectParser<IndexError, String> PARSER = new ConstructingObjectParser("index_error", false, (args, name) -> {
        List lst = (List)args[1];
        int[] shardIds = lst == null ? null : lst.stream().mapToInt(i -> i).toArray();
        String message = args[3] == null ? "" : (String)args[3];
        int stallTime = args[4] == null ? 0 : (Integer)args[4];
        return new IndexError((String)args[0], shardIds, ERROR_TYPE.valueOf(((String)args[2]).toUpperCase(Locale.ROOT)), message, stallTime);
    });

    public IndexError(String indexName, int[] shardIds, ERROR_TYPE errorType, String message, int stallTime) {
        this.indexName = indexName;
        this.shardIds = shardIds;
        this.errorType = errorType;
        this.message = message;
        this.stallTimeSeconds = stallTime;
    }

    public IndexError(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.shardIds = in.readBoolean() ? in.readIntArray() : null;
        this.errorType = (ERROR_TYPE)in.readEnum(ERROR_TYPE.class);
        this.message = in.readString();
        this.stallTimeSeconds = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeBoolean(this.shardIds != null);
        if (this.shardIds != null) {
            out.writeIntArray(this.shardIds);
        }
        out.writeEnum((Enum)this.errorType);
        out.writeString(this.message);
        out.writeVInt(this.stallTimeSeconds);
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public int[] getShardIds() {
        return this.shardIds;
    }

    public ERROR_TYPE getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStallTimeSeconds() {
        return this.stallTimeSeconds;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.indexName);
        if (this.shardIds != null) {
            builder.field("shard_ids", (Object)this.shardIds);
        }
        builder.field("error_type", this.errorType.toString());
        builder.field("message", this.message);
        builder.field("stall_time_seconds", this.stallTimeSeconds);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexError that = (IndexError)o;
        return this.indexName.equals(that.indexName) && Arrays.equals(this.shardIds, that.shardIds) && this.errorType == that.errorType && this.message.equals(that.message) && this.stallTimeSeconds == this.stallTimeSeconds;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.indexName, this.errorType, this.message, this.stallTimeSeconds});
        result = 31 * result + Arrays.hashCode(this.shardIds);
        return result;
    }

    public String toString() {
        return "IndexError{indexName='" + this.indexName + "', shardIds=" + Arrays.toString(this.shardIds) + ", errorType=" + String.valueOf((Object)this.errorType) + ", message='" + this.message + "', stallTimeSeconds=" + this.stallTimeSeconds + "}";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareIntArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("shard_ids", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("error_type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("message", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("stall_time_seconds", new String[0]));
    }

    static enum ERROR_TYPE {
        WARNING,
        EXCEPTION,
        NONE;

    }
}

