/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.tsid;

import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import java.util.List;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;
import org.elasticsearch.xpack.oteldata.otlp.tsid.AttributeListTsidFunnel;

public class ResourceTsidFunnel
implements TsidBuilder.TsidFunnel<ResourceMetrics> {
    private final BufferedByteStringAccessor byteStringAccessor;

    public ResourceTsidFunnel(BufferedByteStringAccessor byteStringAccessor) {
        this.byteStringAccessor = byteStringAccessor;
    }

    public static TsidBuilder forResource(BufferedByteStringAccessor byteStringAccessor, ResourceMetrics resourceMetrics) {
        TsidBuilder tsidBuilder = new TsidBuilder(resourceMetrics.getResource().getAttributesCount());
        new ResourceTsidFunnel(byteStringAccessor).add(resourceMetrics, tsidBuilder);
        return tsidBuilder;
    }

    public void add(ResourceMetrics resourceMetrics, TsidBuilder tsidBuilder) {
        List<KeyValue> resourceAttributes = resourceMetrics.getResource().getAttributesList();
        tsidBuilder.add(resourceAttributes, (TsidBuilder.TsidFunnel)AttributeListTsidFunnel.get(this.byteStringAccessor, "resource.attributes."));
    }
}

