/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOFunction;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.UTF8DecodingReader;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextFamilyFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.extras.SourceConfirmedTextQuery;
import org.elasticsearch.index.mapper.extras.SourceIntervalsSource;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.TextDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentString;

public class MatchOnlyTextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "match_only_text";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers(), MatchOnlyTextFieldMapper.isSyntheticSourceStoredFieldInBinaryFormat(c.indexVersionCreated()), c.isWithinMultiField()));
    private final IndexVersion indexCreatedVersion;
    private final IndexAnalyzers indexAnalyzers;
    private final NamedAnalyzer indexAnalyzer;
    private final int positionIncrementGap;
    private final FieldType fieldType;
    private final boolean storedFieldInBinaryFormat;

    private static boolean isSyntheticSourceStoredFieldInBinaryFormat(IndexVersion indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter((VersionId)IndexVersions.MATCH_ONLY_TEXT_STORED_AS_BYTES) || indexCreatedVersion.between((VersionId)IndexVersions.MATCH_ONLY_TEXT_STORED_AS_BYTES_BACKPORT_8_X, (VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private MatchOnlyTextFieldMapper(String simpleName, FieldType fieldType, MatchOnlyTextFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, builderParams);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        this.fieldType = MatchOnlyTextFieldMapper.freezeAndDeduplicateFieldType((FieldType)fieldType);
        this.indexCreatedVersion = builder.indexCreatedVersion();
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.indexAnalyzer = builder.analyzers.getIndexAnalyzer();
        this.positionIncrementGap = (Integer)builder.analyzers.positionIncrementGap.getValue();
        this.storedFieldInBinaryFormat = builder.storedFieldInBinaryFormat;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.indexAnalyzer);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexAnalyzers, this.storedFieldInBinaryFormat, this.fieldType().isWithinMultiField()).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentString value = context.parser().optimizedTextOrNull();
        if (value == null) {
            return;
        }
        XContentString.UTF8Bytes utfBytes = value.bytes();
        Field field = new Field(this.fieldType().name(), (Reader)new UTF8DecodingReader(utfBytes), (IndexableFieldType)this.fieldType);
        context.doc().add((IndexableField)field);
        context.addToFieldNames(this.fieldType().name());
        if (this.fieldType().textFieldType.storeFieldForSyntheticSource(this.indexCreatedVersion)) {
            if (this.fieldType().canUseSyntheticSourceDelegateForSyntheticSource(value)) {
                return;
            }
            String fieldName = this.fieldType().syntheticSourceFallbackFieldName();
            if (this.storedFieldInBinaryFormat) {
                BytesRef bytesRef = new BytesRef(utfBytes.bytes(), utfBytes.offset(), utfBytes.length());
                context.doc().add((IndexableField)new StoredField(fieldName, bytesRef));
            } else {
                context.doc().add((IndexableField)new StoredField(fieldName, value.string()));
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public MatchOnlyTextFieldType fieldType() {
        return (MatchOnlyTextFieldType)super.fieldType();
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> this.syntheticFieldLoader(this.fullPath(), this.leafName()));
    }

    private SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fullFieldName, String leafFieldName) {
        String fieldName = this.fieldType().syntheticSourceFallbackFieldName();
        CompositeSyntheticFieldLoader.StoredFieldLayer thisFieldLayer = new CompositeSyntheticFieldLoader.StoredFieldLayer(this, fieldName){

            protected void writeValue(Object value, XContentBuilder b) throws IOException {
                if (value instanceof BytesRef) {
                    BytesRef valueBytes = (BytesRef)value;
                    b.value(valueBytes.utf8ToString());
                } else {
                    assert (value instanceof String);
                    b.value(value.toString());
                }
            }
        };
        CompositeSyntheticFieldLoader fieldLoader = new CompositeSyntheticFieldLoader(leafFieldName, fullFieldName, new CompositeSyntheticFieldLoader.Layer[]{thisFieldLayer});
        KeywordFieldMapper kwd = TextFieldMapper.SyntheticSourceHelper.getKeywordFieldMapperForSyntheticSource((Iterable)((Object)this));
        if (kwd != null) {
            CompositeSyntheticFieldLoader kwdFieldLoader = kwd.syntheticFieldLoader(this.fullPath(), this.leafName());
            return fieldLoader.mergedWith(kwdFieldLoader);
        }
        return fieldLoader;
    }

    public static class MatchOnlyTextFieldType
    extends TextFamilyFieldType {
        private final Analyzer indexAnalyzer;
        private final TextFieldMapper.TextFieldType textFieldType;
        private final boolean storedFieldInBinaryFormat;

        public MatchOnlyTextFieldType(String name, TextSearchInfo tsi, Analyzer indexAnalyzer, boolean isSyntheticSource, Map<String, String> meta, boolean withinMultiField, boolean storedFieldInBinaryFormat, KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate) {
            super(name, IndexType.terms((boolean)true, (boolean)false), false, tsi, meta, isSyntheticSource, withinMultiField);
            this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
            this.textFieldType = new TextFieldMapper.TextFieldType(name, isSyntheticSource, withinMultiField, syntheticSourceDelegate);
            this.storedFieldInBinaryFormat = storedFieldInBinaryFormat;
        }

        public MatchOnlyTextFieldType(String name) {
            this(name, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), (Analyzer)Lucene.STANDARD_ANALYZER, false, Collections.emptyMap(), false, false, null);
        }

        private boolean canUseSyntheticSourceDelegateForSyntheticSource(XContentString value) {
            if (this.textFieldType.syntheticSourceDelegate().isPresent()) {
                return !((KeywordFieldMapper.KeywordFieldType)this.textFieldType.syntheticSourceDelegate().get()).ignoreAbove().isIgnored(value);
            }
            return false;
        }

        public String typeName() {
            return MatchOnlyTextFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "text";
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> getValueFetcherProvider(SearchExecutionContext searchExecutionContext) {
            if (!searchExecutionContext.isSourceEnabled()) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [match_only_text] cannot run positional queries since [_source] is disabled.");
            }
            if (searchExecutionContext.isSourceSynthetic()) {
                if (this.isWithinMultiField()) {
                    return this.parentFieldFetcher(searchExecutionContext);
                }
                if (this.textFieldType.syntheticSourceDelegate().isPresent()) {
                    return this.delegateFieldFetcher(searchExecutionContext, (KeywordFieldMapper.KeywordFieldType)this.textFieldType.syntheticSourceDelegate().get());
                }
                return MatchOnlyTextFieldType.storedFieldFetcher(this.name(), this.syntheticSourceFallbackFieldName());
            }
            return this.sourceFieldFetcher(searchExecutionContext);
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> sourceFieldFetcher(SearchExecutionContext searchExecutionContext) {
            return context -> {
                ValueFetcher valueFetcher = this.valueFetcher(searchExecutionContext, null);
                SearchLookup sourceProvider = searchExecutionContext.lookup();
                valueFetcher.setNextReader(context);
                return arg_0 -> MatchOnlyTextFieldType.lambda$sourceFieldFetcher$0(valueFetcher, (SourceProvider)sourceProvider, context, arg_0);
            };
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> parentFieldFetcher(SearchExecutionContext searchExecutionContext) {
            KeywordFieldMapper.KeywordFieldType keywordParent;
            assert (searchExecutionContext.isSourceSynthetic()) : "Synthetic source should be enabled";
            String parentFieldName = searchExecutionContext.parentPath(this.name());
            MappedFieldType parent = searchExecutionContext.lookup().fieldType(parentFieldName);
            if (parent instanceof KeywordFieldMapper.KeywordFieldType && (keywordParent = (KeywordFieldMapper.KeywordFieldType)parent).ignoreAbove().valuesPotentiallyIgnored()) {
                String parentFallbackFieldName = keywordParent.syntheticSourceFallbackFieldName();
                if (parent.isStored()) {
                    return MatchOnlyTextFieldType.storedFieldFetcher(parentFieldName, parentFallbackFieldName);
                }
                if (parent.hasDocValues()) {
                    IndexFieldData ifd = searchExecutionContext.getForField(parent, MappedFieldType.FielddataOperation.SEARCH);
                    return MatchOnlyTextFieldType.combineFieldFetchers(MatchOnlyTextFieldType.docValuesFieldFetcher(ifd), MatchOnlyTextFieldType.storedFieldFetcher(parentFallbackFieldName));
                }
            }
            if (parent.isStored()) {
                return MatchOnlyTextFieldType.storedFieldFetcher(parentFieldName);
            }
            if (parent.hasDocValues()) {
                IndexFieldData ifd = searchExecutionContext.getForField(parent, MappedFieldType.FielddataOperation.SEARCH);
                return MatchOnlyTextFieldType.docValuesFieldFetcher(ifd);
            }
            assert (false) : "parent field should either be stored or have doc values";
            return this.sourceFieldFetcher(searchExecutionContext);
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> delegateFieldFetcher(SearchExecutionContext searchExecutionContext, KeywordFieldMapper.KeywordFieldType keywordDelegate) {
            if (keywordDelegate.ignoreAbove().valuesPotentiallyIgnored()) {
                String fieldName = this.name();
                String fallbackName = this.syntheticSourceFallbackFieldName();
                String delegateFieldName = keywordDelegate.name();
                String delegateFieldFallbackName = keywordDelegate.syntheticSourceFallbackFieldName();
                if (keywordDelegate.isStored()) {
                    return MatchOnlyTextFieldType.storedFieldFetcher(delegateFieldName, delegateFieldFallbackName, fieldName, fallbackName);
                }
                if (keywordDelegate.hasDocValues()) {
                    IndexFieldData ifd = searchExecutionContext.getForField((MappedFieldType)keywordDelegate, MappedFieldType.FielddataOperation.SEARCH);
                    return MatchOnlyTextFieldType.combineFieldFetchers(MatchOnlyTextFieldType.docValuesFieldFetcher(ifd), MatchOnlyTextFieldType.storedFieldFetcher(delegateFieldFallbackName, fieldName, fallbackName));
                }
            }
            if (keywordDelegate.isStored()) {
                return MatchOnlyTextFieldType.storedFieldFetcher(keywordDelegate.name());
            }
            if (keywordDelegate.hasDocValues()) {
                IndexFieldData ifd = searchExecutionContext.getForField((MappedFieldType)keywordDelegate, MappedFieldType.FielddataOperation.SEARCH);
                return MatchOnlyTextFieldType.docValuesFieldFetcher(ifd);
            }
            assert (false) : "multi field should either be stored or have doc values";
            return this.sourceFieldFetcher(searchExecutionContext);
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> docValuesFieldFetcher(IndexFieldData<?> ifd) {
            return context -> {
                SortedBinaryDocValues sortedBinaryDocValues = ifd.load(context).getBytesValues();
                return docId -> {
                    if (sortedBinaryDocValues.advanceExact(docId)) {
                        ArrayList<String> values = new ArrayList<String>(sortedBinaryDocValues.docValueCount());
                        for (int i = 0; i < sortedBinaryDocValues.docValueCount(); ++i) {
                            values.add(sortedBinaryDocValues.nextValue().utf8ToString());
                        }
                        return values;
                    }
                    return List.of();
                };
            };
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> storedFieldFetcher(String ... names) {
            StoredFieldLoader loader = StoredFieldLoader.create((boolean)false, Set.of(names));
            return context -> {
                LeafStoredFieldLoader leafLoader = loader.getLoader(context, null);
                return docId -> {
                    leafLoader.advanceTo(docId);
                    Map storedFields = leafLoader.storedFields();
                    if (names.length == 1) {
                        return (List)storedFields.get(names[0]);
                    }
                    ArrayList values = new ArrayList();
                    for (String name : names) {
                        List currValues = (List)storedFields.get(name);
                        if (currValues == null) continue;
                        values.addAll(currValues);
                    }
                    return values;
                };
            };
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> combineFieldFetchers(IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> primaryFetcher, IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> secondaryFetcher) {
            return context -> {
                CheckedIntFunction primaryGetter = (CheckedIntFunction)primaryFetcher.apply(context);
                CheckedIntFunction secondaryGetter = (CheckedIntFunction)secondaryFetcher.apply(context);
                return docId -> {
                    List secondary;
                    ArrayList values = new ArrayList();
                    List primary = (List)primaryGetter.apply(docId);
                    if (primary != null) {
                        values.addAll(primary);
                    }
                    if ((secondary = (List)secondaryGetter.apply(docId)) != null) {
                        values.addAll(secondary);
                    }
                    assert (primary != null || secondary != null);
                    return values;
                };
            };
        }

        private Query toQuery(Query query, SearchExecutionContext searchExecutionContext) {
            return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(query, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer));
        }

        private IntervalsSource toIntervalsSource(IntervalsSource source, Query approximation, SearchExecutionContext searchExecutionContext) {
            return new SourceIntervalsSource(source, approximation, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            return new ConstantScoreQuery(super.termQuery(value, context));
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, MultiTermQuery.RewriteMethod rewriteMethod) {
            return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
        }

        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.term((BytesRef)term), (Query)new TermQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.prefix((BytesRef)term, (int)IndexSearcher.getMaxClauseCount()), (Query)new PrefixQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, IndexSearcher.getMaxClauseCount(), transpositions, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
            IntervalsSource fuzzyIntervals = Intervals.multiterm((CompiledAutomaton)fuzzyQuery.getAutomata(), (int)IndexSearcher.getMaxClauseCount(), (String)term);
            return this.toIntervalsSource(fuzzyIntervals, (Query)fuzzyQuery, context);
        }

        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.wildcard((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.regexp((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.range((BytesRef)lowerTerm, (BytesRef)upperTerm, (boolean)includeLower, (boolean)includeUpper, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phraseQuery(stream, slop, enablePosIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            KeywordFieldMapper.KeywordFieldType kwd;
            MappedFieldType parent;
            String parentField;
            if (this.isSyntheticSourceEnabled()) {
                if (this.textFieldType.syntheticSourceDelegate().isEmpty()) {
                    if (this.storedFieldInBinaryFormat) {
                        return new BlockStoredFieldsReader.BytesFromBytesRefsBlockLoader(this.syntheticSourceFallbackFieldName());
                    }
                    return new BytesFromMixedStringsBytesRefBlockLoader(this.syntheticSourceFallbackFieldName());
                }
                if (this.textFieldType.canUseSyntheticSourceDelegateForLoading()) {
                    return new BlockLoader.Delegating(((KeywordFieldMapper.KeywordFieldType)this.textFieldType.syntheticSourceDelegate().get()).blockLoader(blContext)){

                        protected String delegatingTo() {
                            return ((KeywordFieldMapper.KeywordFieldType)textFieldType.syntheticSourceDelegate().get()).name();
                        }
                    };
                }
            }
            if ((parentField = blContext.parentField(this.name())) != null && (parent = blContext.lookup().fieldType(parentField)).typeName().equals("keyword") && !(kwd = (KeywordFieldMapper.KeywordFieldType)parent).hasNormalizer() && (kwd.hasDocValues() || kwd.isStored())) {
                return new BlockLoader.Delegating(this, kwd.blockLoader(blContext)){

                    protected String delegatingTo() {
                        return kwd.name();
                    }
                };
            }
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(this.name()), (IndexSettings)blContext.indexSettings());
            BlockSourceReader.LeafIteratorLookup lookup = BlockSourceReader.lookupFromFieldNames((FieldNamesFieldMapper.FieldNamesFieldType)blContext.fieldNames(), (String)this.name());
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, lookup);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            if (fieldDataContext.fielddataOperation() != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalArgumentException("match_only_text fields do not support sorting and aggregations");
            }
            if (this.isSyntheticSourceEnabled()) {
                return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this, this.syntheticSourceFallbackFieldName(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, TextDocValuesField::new){

                    protected BytesRef storedToBytesRef(Object stored) {
                        if (stored instanceof BytesRef) {
                            BytesRef storedBytes = (BytesRef)stored;
                            return storedBytes;
                        }
                        assert (stored instanceof String);
                        return new BytesRef((CharSequence)stored.toString());
                    }
                };
            }
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString((Set)((Set)fieldDataContext.sourcePathsLookup().apply(this.name())), (IndexSettings)fieldDataContext.indexSettings()), (SourceProvider)fieldDataContext.lookupSupplier().get(), TextDocValuesField::new);
        }

        private static /* synthetic */ List lambda$sourceFieldFetcher$0(ValueFetcher valueFetcher, SourceProvider sourceProvider, LeafReaderContext context, int docID) throws IOException {
            try {
                return valueFetcher.fetchValues(sourceProvider.getSource(context, docID), docID, new ArrayList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        static class BytesFromMixedStringsBytesRefBlockLoader
        extends BlockStoredFieldsReader.StoredFieldsBlockLoader {
            BytesFromMixedStringsBytesRefBlockLoader(String field) {
                super(field);
            }

            public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                return factory.bytesRefs(expectedCount);
            }

            public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
                return new BlockStoredFieldsReader.Bytes(this, this.field){
                    private final BytesRef scratch = new BytesRef();

                    protected BytesRef toBytesRef(Object v) {
                        if (v instanceof BytesRef) {
                            BytesRef b = (BytesRef)v;
                            return b;
                        }
                        assert (v instanceof String);
                        return BlockSourceReader.toBytesRef((BytesRef)this.scratch, (String)v.toString());
                    }
                };
            }
        }
    }

    public static class Builder
    extends FieldMapper.TextFamilyBuilder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final TextParams.Analyzers analyzers;
        private final boolean storedFieldInBinaryFormat;

        public Builder(String name, IndexVersion indexCreatedVersion, IndexAnalyzers indexAnalyzers, boolean storedFieldInBinaryFormat, boolean isWithinMultiField) {
            super(name, indexCreatedVersion, isWithinMultiField);
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> ((MatchOnlyTextFieldMapper)m).indexAnalyzer, m -> ((MatchOnlyTextFieldMapper)m).positionIncrementGap, indexCreatedVersion);
            this.storedFieldInBinaryFormat = storedFieldInBinaryFormat;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        private MatchOnlyTextFieldType buildFieldType(MapperBuilderContext context, FieldMapper.MultiFields multiFields) {
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            TextSearchInfo tsi = new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchQuoteAnalyzer);
            return new MatchOnlyTextFieldType(context.buildFullName(this.leafName()), tsi, (Analyzer)indexAnalyzer, context.isSourceSynthetic(), (Map)this.meta.getValue(), this.isWithinMultiField(), this.storedFieldInBinaryFormat, TextFieldMapper.SyntheticSourceHelper.syntheticSourceDelegate((boolean)false, (FieldMapper.MultiFields)multiFields));
        }

        public MatchOnlyTextFieldMapper build(MapperBuilderContext context) {
            FieldMapper.BuilderParams builderParams = this.builderParams((Mapper.Builder)this, context);
            MatchOnlyTextFieldType tft = this.buildFieldType(context, builderParams.multiFields());
            return new MatchOnlyTextFieldMapper(this.leafName(), Defaults.FIELD_TYPE, tft, builderParams, this);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }
}

