/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xpack.analytics.mapper.ExponentialHistogramParser;
import org.elasticsearch.xpack.exponentialhistogram.ExponentialHistogramFieldMapper;
import org.elasticsearch.xpack.exponentialhistogram.aggregations.ExponentialHistogramAggregatorsRegistrar;

public class ExponentialHistogramMapperPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, FieldMapper.TypeParser> mappers = new LinkedHashMap<String, FieldMapper.TypeParser>();
        if (ExponentialHistogramParser.EXPONENTIAL_HISTOGRAM_FEATURE.isEnabled()) {
            mappers.put("exponential_histogram", ExponentialHistogramFieldMapper.PARSER);
        }
        return Collections.unmodifiableMap(mappers);
    }

    public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        if (ExponentialHistogramParser.EXPONENTIAL_HISTOGRAM_FEATURE.isEnabled()) {
            return List.of(ExponentialHistogramAggregatorsRegistrar::registerValueCountAggregator, ExponentialHistogramAggregatorsRegistrar::registerSumAggregator, ExponentialHistogramAggregatorsRegistrar::registerAvgAggregator, ExponentialHistogramAggregatorsRegistrar::registerHistogramAggregator);
        }
        return Collections.emptyList();
    }
}

