/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.request.embeddings;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.common.model.Truncation;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaUtils;

public record NvidiaEmbeddingsRequestEntity(List<String> input, String modelId, InputType inputType, @Nullable Truncation truncation) implements ToXContentObject
{
    public NvidiaEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(modelId);
        Objects.requireNonNull(inputType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("input", this.input);
        builder.field("model", this.modelId);
        builder.field("input_type", NvidiaUtils.inputTypeToString(this.inputType));
        if (this.truncation != null) {
            builder.field("truncate", (Enum)this.truncation);
        }
        builder.endObject();
        return builder;
    }
}

