/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.common.model.Truncation;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaService;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaUtils;

public class NvidiaEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "nvidia_embeddings_task_settings";
    public static final NvidiaEmbeddingsTaskSettings EMPTY_SETTINGS = new NvidiaEmbeddingsTaskSettings(null, null);
    private final InputType inputType;
    private final Truncation truncation;

    public static NvidiaEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, "input_type", "task_settings", InputType::fromString, NvidiaService.VALID_INPUT_TYPE_VALUES, validationException);
        Truncation truncation = ServiceUtils.extractOptionalEnum(map, "truncate", "task_settings", Truncation::fromString, Truncation.ALL, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new NvidiaEmbeddingsTaskSettings(inputType, truncation);
    }

    public static NvidiaEmbeddingsTaskSettings of(NvidiaEmbeddingsTaskSettings originalSettings, NvidiaEmbeddingsTaskSettings requestTaskSettings) {
        if (requestTaskSettings.isEmpty() || originalSettings.equals(requestTaskSettings)) {
            return originalSettings;
        }
        InputType inputTypeToUse = NvidiaEmbeddingsTaskSettings.extractInputTypeToUse(originalSettings, requestTaskSettings);
        Truncation truncationToUse = NvidiaEmbeddingsTaskSettings.extractTruncationToUse(originalSettings, requestTaskSettings);
        return new NvidiaEmbeddingsTaskSettings(inputTypeToUse, truncationToUse);
    }

    private static InputType extractInputTypeToUse(NvidiaEmbeddingsTaskSettings originalSettings, NvidiaEmbeddingsTaskSettings requestTaskSettings) {
        if (requestTaskSettings.getInputType() == null) {
            return originalSettings.getInputType();
        }
        return requestTaskSettings.getInputType();
    }

    private static Truncation extractTruncationToUse(NvidiaEmbeddingsTaskSettings originalSettings, NvidiaEmbeddingsTaskSettings requestTaskSettings) {
        if (requestTaskSettings.getTruncation() == null) {
            return originalSettings.getTruncation();
        }
        return requestTaskSettings.getTruncation();
    }

    public NvidiaEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class), (Truncation)in.readOptionalEnum(Truncation.class));
    }

    public NvidiaEmbeddingsTaskSettings(@Nullable InputType inputType, @Nullable Truncation truncation) {
        NvidiaEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.truncation = truncation;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (NvidiaService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.truncation == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field("input_type", (Enum)this.inputType);
        }
        if (this.truncation != null) {
            builder.field("truncate", (Enum)this.truncation);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Truncation getTruncation() {
        return this.truncation;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return NvidiaUtils.ML_INFERENCE_NVIDIA_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return NvidiaUtils.supportsNvidia(version);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        out.writeOptionalEnum((Enum)this.truncation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NvidiaEmbeddingsTaskSettings that = (NvidiaEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals((Object)this.truncation, (Object)that.truncation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputType, this.truncation});
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        NvidiaEmbeddingsTaskSettings updatedSettings = NvidiaEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return NvidiaEmbeddingsTaskSettings.of(this, updatedSettings);
    }
}

