/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.embeddings;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class NvidiaEmbeddingsServiceSettings
extends NvidiaServiceSettings {
    public static final String NAME = "nvidia_embeddings_service_settings";
    private static final URIBuilder DEFAULT_URI_BUILDER = new URIBuilder().setScheme("https").setHost("integrate.api.nvidia.com").setPathSegments(new String[]{"v1", "embeddings"});
    private final Integer dimensions;
    private final SimilarityMeasure similarity;
    private final Integer maxInputTokens;

    public static NvidiaEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        NvidiaServiceSettings.NvidiaCommonServiceSettings commonServiceSettings = NvidiaEmbeddingsServiceSettings.extractNvidiaCommonServiceSettings(map, context, validationException);
        Integer dimensions = null;
        if (!ConfigurationParseContext.isRequestContext(context)) {
            dimensions = ServiceUtils.extractRequiredPositiveInteger(map, "dimensions", "service_settings", validationException);
        }
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new NvidiaEmbeddingsServiceSettings(commonServiceSettings.model(), commonServiceSettings.uri(), dimensions, similarity, maxInputTokens, commonServiceSettings.rateLimitSettings());
    }

    public NvidiaEmbeddingsServiceSettings(StreamInput in) throws IOException {
        super(in);
        this.dimensions = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.maxInputTokens = in.readOptionalVInt();
    }

    @Override
    protected URI buildDefaultUri() throws URISyntaxException {
        return DEFAULT_URI_BUILDER.build();
    }

    public NvidiaEmbeddingsServiceSettings(String modelId, @Nullable URI uri, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings rateLimitSettings) {
        super(modelId, uri, rateLimitSettings);
        this.dimensions = dimensions;
        this.similarity = similarity;
        this.maxInputTokens = maxInputTokens;
    }

    public NvidiaEmbeddingsServiceSettings(String modelId, @Nullable String url, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createOptionalUri(url), dimensions, similarity, maxInputTokens, rateLimitSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.maxInputTokens);
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.toXContentFragmentOfExposedFields(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NvidiaEmbeddingsServiceSettings that = (NvidiaEmbeddingsServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.dimensions, this.maxInputTokens, this.similarity, this.rateLimitSettings);
    }
}

