/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.completion;

import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaModel;
import org.elasticsearch.xpack.inference.services.nvidia.action.NvidiaActionVisitor;
import org.elasticsearch.xpack.inference.services.nvidia.completion.NvidiaChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class NvidiaChatCompletionModel
extends NvidiaModel {
    public NvidiaChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, NvidiaChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    public NvidiaChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, NvidiaChatCompletionServiceSettings serviceSettings, SecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)EmptyTaskSettings.INSTANCE), new ModelSecrets(secrets));
    }

    public static NvidiaChatCompletionModel of(NvidiaChatCompletionModel model, @Nullable String modelId) {
        if (modelId == null || modelId.equals(model.getServiceSettings().modelId())) {
            return model;
        }
        NvidiaChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        NvidiaChatCompletionServiceSettings overriddenServiceSettings = new NvidiaChatCompletionServiceSettings(modelId, originalModelServiceSettings.uri(), originalModelServiceSettings.rateLimitSettings());
        return new NvidiaChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.getServiceSettings().rateLimitSettings();
    }

    @Override
    public NvidiaChatCompletionServiceSettings getServiceSettings() {
        return (NvidiaChatCompletionServiceSettings)super.getServiceSettings();
    }

    @Override
    public ExecutableAction accept(NvidiaActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this);
    }
}

