/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaServiceSettings;
import org.elasticsearch.xpack.inference.services.nvidia.action.NvidiaActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class NvidiaModel
extends RateLimitGroupingModel {
    protected NvidiaModel(ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
    }

    protected NvidiaModel(RateLimitGroupingModel model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    protected NvidiaModel(RateLimitGroupingModel model, TaskSettings taskSettings) {
        super(model, taskSettings);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.getServiceSettings().rateLimitSettings();
    }

    @Override
    public int rateLimitGroupingHash() {
        NvidiaServiceSettings serviceSettings = this.getServiceSettings();
        return Objects.hash(serviceSettings.uri(), serviceSettings.modelId());
    }

    public NvidiaServiceSettings getServiceSettings() {
        return (NvidiaServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public abstract ExecutableAction accept(NvidiaActionVisitor var1, Map<String, Object> var2);
}

