/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.groq.GroqModel;
import org.elasticsearch.xpack.inference.services.groq.action.GroqActionVisitor;
import org.elasticsearch.xpack.inference.services.groq.completion.GroqChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.groq.completion.GroqChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class GroqChatCompletionModel
extends GroqModel {
    public static GroqChatCompletionModel of(GroqChatCompletionModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        return new GroqChatCompletionModel(model, (GroqChatCompletionTaskSettings)model.getTaskSettings().updatedTaskSettings((Map)taskSettings));
    }

    public static GroqChatCompletionModel of(GroqChatCompletionModel model, UnifiedCompletionRequest request) {
        GroqChatCompletionServiceSettings originalServiceSettings = model.getServiceSettings();
        GroqChatCompletionServiceSettings overriddenServiceSettings = new GroqChatCompletionServiceSettings(Objects.requireNonNullElse(request.model(), originalServiceSettings.modelId()), originalServiceSettings.uri(), originalServiceSettings.organizationId(), originalServiceSettings.rateLimitSettings());
        return new GroqChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getTaskSettings(), model.getSecretSettings());
    }

    public GroqChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GroqChatCompletionServiceSettings.fromMap(serviceSettings, context), new GroqChatCompletionTaskSettings(taskSettings), DefaultSecretSettings.fromMap(secrets));
    }

    GroqChatCompletionModel(String modelId, TaskType taskType, String service, GroqChatCompletionServiceSettings serviceSettings, GroqChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(modelId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, (ApiKeySecrets)secrets, RequestUtils.buildUri(serviceSettings.uri(), "groq", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)GroqChatCompletionModel::buildDefaultUri)));
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.groq.com").setPathSegments(new String[]{"openai", "v1", "chat", "completions"}).build();
    }

    private GroqChatCompletionModel(GroqChatCompletionModel originalModel, GroqChatCompletionTaskSettings taskSettings) {
        super((GroqModel)originalModel, (TaskSettings)taskSettings);
    }

    private GroqChatCompletionModel(GroqChatCompletionModel originalModel, GroqChatCompletionServiceSettings serviceSettings) {
        super((GroqModel)originalModel, (ServiceSettings)serviceSettings);
    }

    public GroqChatCompletionServiceSettings getServiceSettings() {
        return (GroqChatCompletionServiceSettings)super.getServiceSettings();
    }

    public GroqChatCompletionTaskSettings getTaskSettings() {
        return (GroqChatCompletionTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public GroqChatCompletionModel withServiceSettings(GroqChatCompletionServiceSettings serviceSettings) {
        return new GroqChatCompletionModel(this, serviceSettings);
    }

    @Override
    public ExecutableAction accept(GroqActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

