/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.response;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiUnifiedStreamingProcessor;

public class GoogleVertexAiCompletionResponseEntity {
    public static InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk;
        String responseJson = new String(response.body(), StandardCharsets.UTF_8);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, responseJson);){
            XContentUtils.moveToFirstToken(parser);
            chunk = GoogleVertexAiUnifiedStreamingProcessor.GoogleVertexAiChatCompletionChunkParser.parse(parser);
        }
        List<ChatCompletionResults.Result> results = chunk.choices().stream().map(choice -> choice.delta().content()).map(ChatCompletionResults.Result::new).toList();
        return new ChatCompletionResults(results);
    }
}

