/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.response;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;

public class ElasticInferenceServiceAuthorizationResponseEntity
implements InferenceServiceResults {
    public static final String NAME = "elastic_inference_service_auth_results_v2";
    private static final String INFERENCE_ENDPOINTS = "inference_endpoints";
    public static ConstructingObjectParser<ElasticInferenceServiceAuthorizationResponseEntity, Void> PARSER = new ConstructingObjectParser(ElasticInferenceServiceAuthorizationResponseEntity.class.getSimpleName(), true, args -> new ElasticInferenceServiceAuthorizationResponseEntity((List)args[0]));
    private final List<AuthorizedEndpoint> authorizedEndpoints;

    public ElasticInferenceServiceAuthorizationResponseEntity(List<AuthorizedEndpoint> authorizedEndpoints) {
        this.authorizedEndpoints = Objects.requireNonNull(authorizedEndpoints);
    }

    public ElasticInferenceServiceAuthorizationResponseEntity() {
        this(List.of());
    }

    public ElasticInferenceServiceAuthorizationResponseEntity(StreamInput in) throws IOException {
        this(in.readCollectionAsList(AuthorizedEndpoint::new));
    }

    public static ElasticInferenceServiceAuthorizationResponseEntity fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            ElasticInferenceServiceAuthorizationResponseEntity elasticInferenceServiceAuthorizationResponseEntity = (ElasticInferenceServiceAuthorizationResponseEntity)PARSER.apply(jsonParser, null);
            return elasticInferenceServiceAuthorizationResponseEntity;
        }
    }

    public List<AuthorizedEndpoint> getAuthorizedEndpoints() {
        return this.authorizedEndpoints;
    }

    public String toString() {
        return this.authorizedEndpoints.stream().map(AuthorizedEndpoint::toString).collect(Collectors.joining(", "));
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.authorizedEndpoints);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticInferenceServiceAuthorizationResponseEntity that = (ElasticInferenceServiceAuthorizationResponseEntity)o;
        return Objects.equals(this.authorizedEndpoints, that.authorizedEndpoints);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedEndpoints);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> AuthorizedEndpoint.AUTHORIZED_ENDPOINT_PARSER.apply(arg_0, arg_1), new ParseField(INFERENCE_ENDPOINTS, new String[0]));
    }

    public record AuthorizedEndpoint(String id, String modelName, TaskTypeObject taskType, String status, @Nullable List<String> properties, String releaseDate, @Nullable String endOfLifeDate, @Nullable Configuration configuration) implements Writeable,
    ToXContentObject
    {
        private static final String ID = "id";
        private static final String MODEL_NAME = "model_name";
        private static final String TASK_TYPE = "task_types";
        private static final String STATUS = "status";
        private static final String PROPERTIES = "properties";
        private static final String RELEASE_DATE = "release_date";
        private static final String END_OF_LIFE_DATE = "end_of_life_date";
        private static final String CONFIGURATION = "configuration";
        public static ConstructingObjectParser<AuthorizedEndpoint, Void> AUTHORIZED_ENDPOINT_PARSER = new ConstructingObjectParser(AuthorizedEndpoint.class.getSimpleName(), true, args -> new AuthorizedEndpoint((String)args[0], (String)args[1], (TaskTypeObject)args[2], (String)args[3], (List)args[4], (String)args[5], (String)args[6], (Configuration)args[7]));

        public AuthorizedEndpoint(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), new TaskTypeObject(in), in.readString(), in.readOptionalCollectionAsList(StreamInput::readString), in.readString(), in.readOptionalString(), (Configuration)in.readOptionalWriteable(Configuration::new));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeString(this.modelName);
            this.taskType.writeTo(out);
            out.writeString(this.status);
            out.writeOptionalCollection(this.properties, StreamOutput::writeString);
            out.writeString(this.releaseDate);
            out.writeOptionalString(this.endOfLifeDate);
            out.writeOptionalWriteable((Writeable)this.configuration);
        }

        @Override
        public String toString() {
            return Strings.format((String)"AuthorizedEndpoint{id='%s', modelName='%s', taskType='%s', status='%s', properties=%s, releaseDate='%s', endOfLifeDate='%s', configuration=%s}", (Object[])new Object[]{this.id, this.modelName, this.taskType, this.status, this.properties, this.releaseDate, this.endOfLifeDate, this.configuration});
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ID, this.id);
            builder.field(MODEL_NAME, this.modelName);
            builder.field(TASK_TYPE, (ToXContent)this.taskType);
            builder.field(STATUS, this.status);
            if (this.properties != null) {
                builder.field(PROPERTIES, this.properties);
            }
            builder.field(RELEASE_DATE, this.releaseDate);
            if (this.endOfLifeDate != null) {
                builder.field(END_OF_LIFE_DATE, this.endOfLifeDate);
            }
            if (this.configuration != null) {
                builder.field(CONFIGURATION, (ToXContent)this.configuration);
            }
            builder.endObject();
            return builder;
        }

        static {
            AUTHORIZED_ENDPOINT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ID, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(MODEL_NAME, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> TaskTypeObject.PARSER.apply(arg_0, arg_1), new ParseField(TASK_TYPE, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATUS, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField(PROPERTIES, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(RELEASE_DATE, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(END_OF_LIFE_DATE, new String[0]));
            AUTHORIZED_ENDPOINT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> Configuration.PARSER.apply(arg_0, arg_1), new ParseField(CONFIGURATION, new String[0]));
        }
    }

    public record Configuration(@Nullable String similarity, @Nullable Integer dimensions, @Nullable String elementType, @Nullable Map<String, Object> chunkingSettings) implements Writeable,
    ToXContentObject
    {
        public static final Configuration EMPTY = new Configuration(null, null, null, null);
        public static final String SIMILARITY = "similarity";
        public static final String DIMENSIONS = "dimensions";
        public static final String ELEMENT_TYPE = "element_type";
        public static final String CHUNKING_SETTINGS = "chunking_settings";
        public static final ConstructingObjectParser<Configuration, Void> PARSER = new ConstructingObjectParser(Configuration.class.getSimpleName(), true, args -> new Configuration((String)args[0], (Integer)args[1], (String)args[2], (Map)args[3]));

        public Configuration(StreamInput in) throws IOException {
            this(in.readOptionalString(), in.readOptionalVInt(), in.readOptionalString(), in.readGenericMap());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.similarity);
            out.writeOptionalVInt(this.dimensions);
            out.writeOptionalString(this.elementType);
            out.writeGenericMap(this.chunkingSettings);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.similarity != null) {
                builder.field(SIMILARITY, this.similarity);
            }
            if (this.dimensions != null) {
                builder.field(DIMENSIONS, this.dimensions);
            }
            if (this.elementType != null) {
                builder.field(ELEMENT_TYPE, this.elementType);
            }
            if (this.chunkingSettings != null) {
                builder.field(CHUNKING_SETTINGS, this.chunkingSettings);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.format((String)"Configuration{similarity='%s', dimensions=%s, elementType='%s', chunkingSettings=%s}", (Object[])new Object[]{this.similarity, this.dimensions, this.elementType, this.chunkingSettings});
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SIMILARITY, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DIMENSIONS, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ELEMENT_TYPE, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), new ParseField(CHUNKING_SETTINGS, new String[0]));
        }
    }

    public record TaskTypeObject(String eisTaskType, String elasticsearchTaskType) implements Writeable,
    ToXContentObject
    {
        private static final String EIS_TASK_TYPE_FIELD = "eis";
        private static final String ELASTICSEARCH_TASK_TYPE_FIELD = "elasticsearch";
        private static final ConstructingObjectParser<TaskTypeObject, Void> PARSER = new ConstructingObjectParser(TaskTypeObject.class.getSimpleName(), true, args -> new TaskTypeObject((String)args[0], (String)args[1]));

        public TaskTypeObject(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public String toString() {
            return Strings.format((String)"TaskTypeObject{eisTaskType='%s', elasticsearchTaskType='%s'}", (Object[])new Object[]{this.eisTaskType, this.elasticsearchTaskType});
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.eisTaskType);
            out.writeString(this.elasticsearchTaskType);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.eisTaskType != null) {
                builder.field(EIS_TASK_TYPE_FIELD, this.eisTaskType);
            }
            builder.field(ELASTICSEARCH_TASK_TYPE_FIELD, this.elasticsearchTaskType);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(EIS_TASK_TYPE_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ELASTICSEARCH_TASK_TYPE_FIELD, new String[0]));
        }
    }
}

