/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;

public class CCMInformedSettings
extends ElasticInferenceServiceSettings {
    static final String DEFAULT_CCM_URL = "https://inference.us-east-1.aws.svc.elastic.cloud";
    private final CCMFeature ccmFeature;

    public CCMInformedSettings(Settings settings, CCMFeature ccmFeature) {
        super(settings);
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    @Override
    public String getElasticInferenceServiceUrl() {
        String urlFromSettings = super.getElasticInferenceServiceUrl();
        if (!this.ccmFeature.isCcmSupportedEnvironment() || !Strings.isNullOrEmpty((String)urlFromSettings)) {
            return urlFromSettings;
        }
        return DEFAULT_CCM_URL;
    }
}

