/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.authorization;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.inference.InferenceFeatures;
import org.elasticsearch.xpack.inference.common.BroadcastMessageAction;
import org.elasticsearch.xpack.inference.services.elastic.authorization.AuthorizationPoller;
import org.elasticsearch.xpack.inference.services.elastic.authorization.AuthorizationTaskParams;

public class AuthorizationTaskExecutor
extends PersistentTasksExecutor<AuthorizationTaskParams>
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AuthorizationTaskExecutor.class);
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final AuthorizationPoller.Parameters pollerParameters;
    private final AtomicReference<AuthorizationPoller> currentTask = new AtomicReference();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final FeatureService featureService;

    public static AuthorizationTaskExecutor create(ClusterService clusterService, FeatureService featureService, AuthorizationPoller.Parameters parameters) {
        Objects.requireNonNull(clusterService);
        Objects.requireNonNull(parameters);
        return new AuthorizationTaskExecutor(clusterService, new PersistentTasksService(clusterService, parameters.serviceComponents().threadPool(), parameters.client()), featureService, parameters);
    }

    AuthorizationTaskExecutor(ClusterService clusterService, PersistentTasksService persistentTasksService, FeatureService featureService, AuthorizationPoller.Parameters pollerParameters) {
        super("eis-authorization-poller", (Executor)pollerParameters.serviceComponents().threadPool().executor("inference_utility"));
        this.clusterService = Objects.requireNonNull(clusterService);
        this.featureService = Objects.requireNonNull(featureService);
        this.persistentTasksService = Objects.requireNonNull(persistentTasksService);
        this.pollerParameters = Objects.requireNonNull(pollerParameters);
    }

    public synchronized void startAndLazyCreateTask() {
        this.startInternal(false);
    }

    public synchronized void startAndImmediatelyCreateTask() {
        this.startInternal(true);
    }

    private void startInternal(boolean createPersistentTask) {
        String eisUrl = this.pollerParameters.elasticInferenceServiceSettings().getElasticInferenceServiceUrl();
        logger.info("Authorization task executor EIS URL: [{}]", (Object)eisUrl);
        if (!Strings.isNullOrEmpty((String)eisUrl) && this.running.compareAndSet(false, true)) {
            logger.info("Starting authorization task executor");
            if (createPersistentTask) {
                this.sendStartRequest(this.clusterService.state());
            }
            this.clusterService.addListener((ClusterStateListener)this);
        }
    }

    private void sendStartRequest(@Nullable ClusterState state) {
        if (this.shouldSkipCreatingTask(state)) {
            return;
        }
        this.persistentTasksService.sendClusterStartRequest("eis-authorization-poller", "eis-authorization-poller", (PersistentTaskParams)AuthorizationTaskParams.INSTANCE, TimeValue.THIRTY_SECONDS, ActionListener.wrap(persistentTask -> logger.info("Finished creating authorization poller task, id {}", (Object)persistentTask.getId()), exception -> {
            Throwable thrownException;
            Throwable throwable = thrownException = exception instanceof RemoteTransportException ? exception.getCause() : exception;
            if (!(thrownException instanceof ResourceAlreadyExistsException)) {
                logger.error("Failed to create authorization poller task", (Throwable)exception);
            }
        }));
    }

    private boolean shouldSkipCreatingTask(@Nullable ClusterState state) {
        if (state == null) {
            return true;
        }
        return !this.clusterCanSupportFeature(state) || !this.running.get() || AuthorizationTaskExecutor.authorizationTaskExists(state);
    }

    private boolean clusterCanSupportFeature(@Nullable ClusterState state) {
        if (state == null) {
            return false;
        }
        return state.clusterRecovered() && this.featureService.clusterHasFeature(state, InferenceFeatures.INFERENCE_AUTH_POLLER_PERSISTENT_TASK);
    }

    private static boolean authorizationTaskExists(@Nullable ClusterState state) {
        if (state == null) {
            return false;
        }
        return ClusterPersistentTasksCustomMetadata.getTaskWithId((ClusterState)state, (String)"eis-authorization-poller") != null;
    }

    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            logger.info("Shutting down authorization task executor");
            this.clusterService.removeListener((ClusterStateListener)this);
            this.sendStopRequest();
        }
    }

    private void sendStopRequest() {
        this.persistentTasksService.sendClusterRemoveRequest("eis-authorization-poller", TimeValue.THIRTY_SECONDS, ActionListener.wrap(persistentTask -> logger.info("Stopped authorization poller task, id {}", (Object)persistentTask.getId()), exception -> {
            Throwable thrownException;
            Throwable throwable = thrownException = exception instanceof RemoteTransportException ? exception.getCause() : exception;
            if (!(thrownException instanceof ResourceNotFoundException)) {
                logger.error("Failed to stop authorization poller task", (Throwable)exception);
            }
        }));
    }

    public AuthorizationPoller getCurrentPollerTask() {
        return this.currentTask.get();
    }

    protected void nodeOperation(AllocatedPersistentTask task, AuthorizationTaskParams params, PersistentTaskState state) {
        AuthorizationPoller authPoller = (AuthorizationPoller)task;
        this.currentTask.set(authPoller);
        authPoller.start();
        logger.info("Started authorization poller task with id {}", (Object)task.getId());
    }

    public PersistentTasksExecutor.Scope scope() {
        return PersistentTasksExecutor.Scope.CLUSTER;
    }

    protected AuthorizationPoller createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<AuthorizationTaskParams> taskInProgress, Map<String, String> headers) {
        return AuthorizationPoller.create(new AuthorizationPoller.TaskFields(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers), this.pollerParameters);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.sendStartRequest(event.state());
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("eis-authorization-poller", new String[0]), AuthorizationTaskParams::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "eis-authorization-poller", AuthorizationTaskParams::new));
    }

    public record Message(boolean enable) implements Writeable
    {
        public static final Message ENABLE_MESSAGE = new Message(true);
        public static final Message DISABLE_MESSAGE = new Message(false);

        public Message(StreamInput in) throws IOException {
            this(in.readBoolean());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.enable);
        }
    }

    public static class Action
    extends BroadcastMessageAction<Message> {
        public static final String NAME = "cluster:internal/xpack/inference/update_authorization_task";
        public static final ActionType<BroadcastMessageAction.Response> INSTANCE = new ActionType("cluster:internal/xpack/inference/update_authorization_task");
        private final AuthorizationTaskExecutor authorizationTaskExecutor;

        @Inject
        public Action(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AuthorizationTaskExecutor authorizationTaskExecutor) {
            super(NAME, clusterService, transportService, actionFilters, Message::new);
            this.authorizationTaskExecutor = authorizationTaskExecutor;
        }

        @Override
        protected void receiveMessage(Message message) {
            if (message.enable()) {
                this.authorizationTaskExecutor.startAndImmediatelyCreateTask();
            } else {
                this.authorizationTaskExecutor.stop();
            }
        }
    }
}

