/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.action.AzureOpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AzureOpenAiModel
extends RateLimitGroupingModel {
    protected URI uri;
    private final AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings;

    public AzureOpenAiModel(ModelConfigurations configurations, ModelSecrets secrets, AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
    }

    protected AzureOpenAiModel(AzureOpenAiModel model, TaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
        this.uri = model.getUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    protected AzureOpenAiModel(AzureOpenAiModel model, ServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.uri = model.getUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public abstract ExecutableAction accept(AzureOpenAiActionVisitor var1, Map<String, Object> var2);

    public final URI buildUriString() throws URISyntaxException {
        return AzureOpenAiModel.buildUri(this.resourceName(), this.deploymentId(), this.apiVersion(), this.operationPathSegments());
    }

    public static URI buildUri(String resourceName, String deploymentId, String apiVersion, String ... pathSegments) throws URISyntaxException {
        String hostname = Strings.format((String)"%s.%s", (Object[])new Object[]{resourceName, "openai.azure.com"});
        return new URIBuilder().setScheme("https").setHost(hostname).setPathSegments(AzureOpenAiModel.createPathSegmentsList(deploymentId, pathSegments)).addParameter("api-version", apiVersion).build();
    }

    private static List<String> createPathSegmentsList(String deploymentId, String[] pathSegments) {
        ArrayList<String> pathSegmentsList = new ArrayList<String>(List.of("openai", "deployments", deploymentId));
        pathSegmentsList.addAll(Arrays.asList(pathSegments));
        return pathSegmentsList;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI newUri) {
        this.uri = newUri;
    }

    public AzureOpenAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings.rateLimitSettings();
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.resourceName(), this.deploymentId());
    }

    public abstract String resourceName();

    public abstract String deploymentId();

    public abstract String apiVersion();

    public abstract String[] operationPathSegments();
}

