/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.rerank;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record AzureAiStudioRerankRequestTaskSettings(@Nullable Boolean returnDocuments, @Nullable Integer topN) {
    public static final AzureAiStudioRerankRequestTaskSettings EMPTY_SETTINGS = new AzureAiStudioRerankRequestTaskSettings(null, null);

    public static AzureAiStudioRerankRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, "return_documents", validationException);
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, "top_n", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioRerankRequestTaskSettings(returnDocuments, topN);
    }
}

