/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.ChunkScorerConfig;

public class TextSimilarityRankDoc
extends RankDoc {
    public static final NodeFeature TEXT_SIMILARITY_RANK_DOC_EXPLAIN_CHUNKS = new NodeFeature("text_similarity_rank_doc_explain_chunks");
    private static final TransportVersion TEXT_SIMILARITY_RANK_DOC_EXPLAIN_CHUNKS_VERSION = TransportVersion.fromName((String)"text_similarity_rank_docs_explain_chunks");
    public static final String NAME = "text_similarity_rank_doc";
    public final String inferenceId;
    public final String field;
    public final ChunkScorerConfig chunkScorerConfig;

    public TextSimilarityRankDoc(int doc, float score, int shardIndex) {
        this(doc, score, shardIndex, null, null, null);
    }

    public TextSimilarityRankDoc(int doc, float score, int shardIndex, String inferenceId, String field, ChunkScorerConfig chunkScorerConfig) {
        super(doc, score, shardIndex);
        this.inferenceId = inferenceId;
        this.field = field;
        this.chunkScorerConfig = chunkScorerConfig;
    }

    public TextSimilarityRankDoc(StreamInput in) throws IOException {
        super(in);
        boolean hasChunkScorerConfig;
        this.inferenceId = in.readOptionalString();
        this.field = in.readOptionalString();
        this.chunkScorerConfig = in.getTransportVersion().supports(TEXT_SIMILARITY_RANK_DOC_EXPLAIN_CHUNKS_VERSION) ? ((hasChunkScorerConfig = in.readBoolean()) ? new ChunkScorerConfig(in) : null) : null;
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        assert (this.inferenceId != null && this.field != null);
        String queryAlias = queryNames[0] == null ? "" : "[" + queryNames[0] + "]";
        StringBuilder sb = new StringBuilder();
        sb.append("text_similarity_reranker match using inference endpoint: [").append(this.inferenceId).append("] on document field: [").append(this.field).append("] matching on source query ").append(queryAlias);
        if (this.chunkScorerConfig != null) {
            sb.append("and rescoring considering only top [").append(this.chunkScorerConfig.sizeOrDefault()).append("] best chunks");
        }
        return Explanation.match((Number)Float.valueOf(this.score), (String)sb.toString(), (Explanation[])sources);
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.inferenceId);
        out.writeOptionalString(this.field);
        if (out.getTransportVersion().supports(TEXT_SIMILARITY_RANK_DOC_EXPLAIN_CHUNKS_VERSION)) {
            boolean hasChunkScorerConfig = this.chunkScorerConfig != null;
            out.writeBoolean(hasChunkScorerConfig);
            if (hasChunkScorerConfig) {
                this.chunkScorerConfig.writeTo(out);
            }
        }
    }

    public boolean doEquals(RankDoc rd) {
        TextSimilarityRankDoc tsrd = (TextSimilarityRankDoc)rd;
        return Objects.equals(this.inferenceId, tsrd.inferenceId) && Objects.equals(this.field, tsrd.field) && Objects.equals(this.chunkScorerConfig, tsrd.chunkScorerConfig);
    }

    public int doHashCode() {
        return Objects.hash(this.inferenceId, this.field, this.chunkScorerConfig);
    }

    public String toString() {
        return "TextSimilarityRankDoc{doc=" + this.doc + ", shardIndex=" + this.shardIndex + ", score=" + this.score + ", inferenceId=" + this.inferenceId + ", field=" + this.field + ", chunkScorerConfig=" + String.valueOf(this.chunkScorerConfig) + "}";
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.inferenceId != null) {
            builder.field("inferenceId", this.inferenceId);
        }
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.chunkScorerConfig != null) {
            builder.field("chunkScorerConfig", (ToXContent)this.chunkScorerConfig);
        }
    }
}

