/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.StreamingHttpResult;
import org.elasticsearch.xpack.inference.external.http.StreamingHttpResultPublisher;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpClient
implements Closeable {
    private static final Logger logger = LogManager.getLogger(HttpClient.class);
    private final CloseableHttpAsyncClient client;
    private final ThreadPool threadPool;
    private final HttpSettings settings;
    private final ThrottlerManager throttlerManager;

    public static HttpClient create(HttpSettings settings, ThreadPool threadPool, PoolingNHttpClientConnectionManager connectionManager, ThrottlerManager throttlerManager) {
        CloseableHttpAsyncClient client = HttpClient.createAsyncClient(Objects.requireNonNull(connectionManager), Objects.requireNonNull(settings));
        return new HttpClient(settings, client, threadPool, throttlerManager);
    }

    private static CloseableHttpAsyncClient createAsyncClient(PoolingNHttpClientConnectionManager connectionManager, HttpSettings settings) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(settings.connectionTimeout()).build();
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create().setConnectionManager((NHttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
        clientBuilder.disableCookieManagement();
        clientBuilder.disableConnectionState();
        return clientBuilder.build();
    }

    HttpClient(HttpSettings settings, CloseableHttpAsyncClient asyncClient, ThreadPool threadPool, ThrottlerManager throttlerManager) {
        this.settings = Objects.requireNonNull(settings);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(asyncClient);
        this.throttlerManager = Objects.requireNonNull(throttlerManager);
    }

    public void start() {
        this.client.start();
    }

    public void send(final HttpRequest request, HttpClientContext context, final ActionListener<HttpResult> listener) throws IOException {
        SocketAccess.doPrivileged(() -> this.client.execute((HttpUriRequest)request.httpRequestBase(), (HttpContext)context, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                HttpClient.this.respondUsingResponseThread(response, request, (ActionListener<HttpResult>)listener);
            }

            public void failed(Exception ex) {
                HttpClient.this.throttlerManager.warn(logger, Strings.format((String)"Request from inference entity id [%s] failed", (Object[])new Object[]{request.inferenceEntityId()}), ex);
                HttpClient.this.failUsingResponseThread(HttpClient.getException(ex), listener);
            }

            public void cancelled() {
                HttpClient.this.failUsingResponseThread(new CancellationException(Strings.format((String)"Request from inference entity id [%s] was cancelled", (Object[])new Object[]{request.inferenceEntityId()})), listener);
            }
        }));
    }

    private void respondUsingResponseThread(HttpResponse response, HttpRequest request, ActionListener<HttpResult> listener) {
        this.threadPool.executor("inference_response").execute(() -> {
            try {
                listener.onResponse((Object)HttpResult.create(this.settings.getMaxResponseSize(), response));
            }
            catch (Exception e) {
                this.throttlerManager.warn(logger, Strings.format((String)"Failed to create http result from inference entity id [%s]", (Object[])new Object[]{request.inferenceEntityId()}), e);
                listener.onFailure(e);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        });
    }

    private void failUsingResponseThread(Exception exception, ActionListener<?> listener) {
        this.threadPool.executor("inference_response").execute(() -> listener.onFailure(exception));
    }

    private static Exception getException(Exception e) {
        if (e instanceof CancellationException) {
            CancellationException cancellationException = (CancellationException)e;
            return HttpClient.createNotRunningException(cancellationException);
        }
        return e;
    }

    private static IllegalStateException createNotRunningException(Exception exception) {
        return new IllegalStateException("Http client is not running, please retry the request", exception);
    }

    public void stream(final HttpRequest request, HttpContext context, ActionListener<StreamingHttpResult> listener) throws IOException {
        final StreamingHttpResultPublisher streamingProcessor = new StreamingHttpResultPublisher(this.threadPool, this.settings, listener);
        SocketAccess.doPrivileged(() -> this.client.execute(request.requestProducer(), (HttpAsyncResponseConsumer)streamingProcessor, context, (FutureCallback)new FutureCallback<Void>(){

            public void completed(Void response) {
                streamingProcessor.close();
            }

            public void failed(Exception ex) {
                HttpClient.this.threadPool.executor("inference_response").execute(() -> streamingProcessor.failed(HttpClient.getException(ex)));
            }

            public void cancelled() {
                HttpClient.this.threadPool.executor("inference_response").execute(() -> streamingProcessor.failed(new CancellationException(Strings.format((String)"Request from inference entity id [%s] was cancelled", (Object[])new Object[]{request.inferenceEntityId()}))));
            }
        }));
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

