/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.core.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;
import org.elasticsearch.xpack.core.exponentialhistogram.fielddata.LeafExponentialHistogramFieldData;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateSubMetricFieldValueFetcher;
import org.elasticsearch.xpack.downsample.ExponentialHistogramMetricFieldProducer;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;
import org.elasticsearch.xpack.downsample.NumericMetricFieldProducer;

class FieldValueFetcher {
    protected final String name;
    protected final MappedFieldType fieldType;
    protected final IndexFieldData<?> fieldData;
    protected final AbstractDownsampleFieldProducer<?> fieldProducer;

    protected FieldValueFetcher(String name, MappedFieldType fieldType, IndexFieldData<?> fieldData, DownsampleConfig.SamplingMethod samplingMethod) {
        this.name = name;
        this.fieldType = fieldType;
        this.fieldData = fieldData;
        this.fieldProducer = this.createFieldProducer(samplingMethod);
    }

    public String name() {
        return this.name;
    }

    public FormattedDocValues getLeaf(LeafReaderContext context) {
        DocValueFormat format = this.fieldType.docValueFormat(null, null);
        return this.fieldData.load(context).getFormattedValues(format);
    }

    public SortedNumericDoubleValues getNumericLeaf(LeafReaderContext context) {
        LeafNumericFieldData numericFieldData = (LeafNumericFieldData)this.fieldData.load(context);
        return numericFieldData.getDoubleValues();
    }

    public ExponentialHistogramValuesReader getExponentialHistogramLeaf(LeafReaderContext context) throws IOException {
        LeafExponentialHistogramFieldData exponentialHistogramFieldData = (LeafExponentialHistogramFieldData)this.fieldData.load(context);
        return exponentialHistogramFieldData.getHistogramValues();
    }

    AbstractDownsampleFieldProducer<?> fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer<?> createFieldProducer(DownsampleConfig.SamplingMethod samplingMethod) {
        assert (!"aggregate_metric_double".equals(this.fieldType.typeName())) : "Aggregate metric double should be handled by a dedicated FieldValueFetcher";
        if (this.fieldType.getMetricType() != null) {
            return switch (this.fieldType.getMetricType()) {
                default -> throw new MatchException(null, null);
                case TimeSeriesParams.MetricType.GAUGE -> NumericMetricFieldProducer.createFieldProducerForGauge(this.name(), samplingMethod);
                case TimeSeriesParams.MetricType.COUNTER -> LastValueFieldProducer.createForMetric(this.name());
                case TimeSeriesParams.MetricType.HISTOGRAM -> {
                    if ("exponential_histogram".equals(this.fieldType.typeName())) {
                        yield ExponentialHistogramMetricFieldProducer.createMetricProducerForExponentialHistogram(this.name(), samplingMethod);
                    }
                    throw new IllegalArgumentException("Time series metrics supports only exponential histogram");
                }
                case TimeSeriesParams.MetricType.POSITION -> throw new IllegalArgumentException("Unsupported metric type [position] for down-sampling");
            };
        }
        return LastValueFieldProducer.createForLabel(this.name(), this.fieldType.typeName());
    }

    static List<FieldValueFetcher> create(SearchExecutionContext context, String[] fields, Map<String, String> multiFieldSources, DownsampleConfig.SamplingMethod samplingMethod) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            IndexFieldData fieldData;
            String sourceField = multiFieldSources.getOrDefault(field, field);
            MappedFieldType fieldType = context.getFieldType(sourceField);
            assert (fieldType != null) : "Unknown field type for field: [" + sourceField + "]";
            if (fieldType instanceof AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType) {
                AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType aggMetricFieldType = (AggregateMetricDoubleFieldMapper.AggregateMetricDoubleFieldType)fieldType;
                fetchers.addAll(AggregateSubMetricFieldValueFetcher.create(context, aggMetricFieldType, samplingMethod));
                continue;
            }
            if (!context.fieldExistsInIndex(field)) continue;
            if (fieldType instanceof FlattenedFieldMapper.RootFlattenedFieldType) {
                FlattenedFieldMapper.RootFlattenedFieldType flattenedFieldType = (FlattenedFieldMapper.RootFlattenedFieldType)fieldType;
                MappedFieldType keyedFieldType = flattenedFieldType.getKeyedFieldType();
                fieldData = context.getForField(keyedFieldType, MappedFieldType.FielddataOperation.SEARCH);
            } else {
                fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            }
            fetchers.add(new FieldValueFetcher(field, fieldType, fieldData, samplingMethod));
        }
        return Collections.unmodifiableList(fetchers);
    }
}

