/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.AggNameInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public abstract class AggregateFunction
extends Function {
    private final Expression field;
    private final List<? extends Expression> parameters;

    protected AggregateFunction(Source source, Expression field) {
        this(source, field, Collections.emptyList());
    }

    protected AggregateFunction(Source source, Expression field, List<? extends Expression> parameters) {
        super(source, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    public Expression field() {
        return this.field;
    }

    public List<? extends Expression> parameters() {
        return this.parameters;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact(this.field, this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected Pipe makePipe() {
        return new AggNameInput(this.source(), (Expression)this, this.sourceText());
    }

    @Override
    public ScriptTemplate asScript() {
        throw new QlIllegalArgumentException("Aggregate functions cannot be scripted");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.children());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AggregateFunction other = (AggregateFunction)obj;
            return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
        }
        return false;
    }
}

