/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestPostDataAction
extends BaseRestHandler {
    private static final String DEFAULT_RESET_START = "";
    private static final String DEFAULT_RESET_END = "";

    public List<RestHandler.Route> routes() {
        String msg = "Posting data directly to anomaly detection jobs is deprecated, in a future major version it will be compulsory to use a datafeed";
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/_data")).deprecateAndKeep("Posting data directly to anomaly detection jobs is deprecated, in a future major version it will be compulsory to use a datafeed").build());
    }

    public String getName() {
        return "ml_post_data_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PostDataAction.Request request = new PostDataAction.Request(restRequest.param(Job.ID.getPreferredName()));
        request.setResetStart(restRequest.param(PostDataAction.Request.RESET_START.getPreferredName(), ""));
        request.setResetEnd(restRequest.param(PostDataAction.Request.RESET_END.getPreferredName(), ""));
        ReleasableBytesReference content = restRequest.content();
        request.setContent((BytesReference)content, restRequest.getXContentType());
        return channel -> client.execute((ActionType)PostDataAction.INSTANCE, (ActionRequest)request, ActionListener.withRef((ActionListener)new RestToXContentListener(channel, r -> RestStatus.ACCEPTED), (RefCounted)content));
    }

    public boolean mediaTypesValid(RestRequest request) {
        return super.mediaTypesValid(request) && XContentType.supportsDelimitedBulkRequests((XContentType)request.getXContentType());
    }
}

