/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.cat;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.security.user.InternalUsers;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCatTrainedModelsAction
extends AbstractCatAction {
    private final boolean areDataFrameAnalyticsEnabled;

    public RestCatTrainedModelsAction(boolean areDataFrameAnalyticsEnabled) {
        this.areDataFrameAnalyticsEnabled = areDataFrameAnalyticsEnabled;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/trained_models"), new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/trained_models/{" + String.valueOf(TrainedModelConfig.MODEL_ID) + "}"));
    }

    public String getName() {
        return "cat_ml_get_trained_models_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest restRequest, final NodeClient client) {
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)modelId)) {
            modelId = "_all";
        }
        final GetTrainedModelsStatsAction.Request statsRequest = new GetTrainedModelsStatsAction.Request(modelId);
        final GetTrainedModelsAction.Request modelsAction = new GetTrainedModelsAction.Request(modelId, null, Collections.emptySet());
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            statsRequest.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            modelsAction.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        statsRequest.setAllowNoResources(true);
        modelsAction.setAllowNoResources(restRequest.paramAsBoolean(GetTrainedModelsAction.Request.ALLOW_NO_MATCH.getPreferredName(), statsRequest.isAllowNoResources()));
        return new BaseRestHandler.RestChannelConsumer(){
            private List<GetTrainedModelsStatsAction.Response.TrainedModelStats> trainedModelsStats;
            private List<DataFrameAnalyticsConfig> dataFrameAnalytics;

            public void accept(RestChannel channel) {
                SubscribableListener.newForked(this::getTrainedModels).andThen(this::getDerivedData).addListener(this.newRestListener(channel));
            }

            private void getTrainedModels(ActionListener<GetTrainedModelsAction.Response> listener) {
                client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)modelsAction, listener);
            }

            private void getDerivedData(ActionListener<GetTrainedModelsAction.Response> listener, GetTrainedModelsAction.Response trainedModels) {
                List trainedModelConfigs = trainedModels.getResources().results();
                HashSet potentialAnalyticsIds = new HashSet();
                trainedModelConfigs.stream().filter(c -> InternalUsers.XPACK_USER.principal().equals(c.getCreatedBy())).forEach(c -> potentialAnalyticsIds.addAll(c.getTags()));
                String requestIdPattern = Strings.collectionToDelimitedString(potentialAnalyticsIds, (String)"*,") + "*";
                try (RefCountingListener listeners = new RefCountingListener(listener.map(ignored -> trainedModels));){
                    client.execute((ActionType)GetTrainedModelsStatsAction.INSTANCE, (ActionRequest)statsRequest, listeners.acquire(response -> {
                        this.trainedModelsStats = response.getResources().results();
                    }));
                    if (RestCatTrainedModelsAction.this.areDataFrameAnalyticsEnabled) {
                        GetDataFrameAnalyticsAction.Request dataFrameAnalyticsRequest = new GetDataFrameAnalyticsAction.Request(requestIdPattern);
                        dataFrameAnalyticsRequest.setAllowNoResources(true);
                        dataFrameAnalyticsRequest.setPageParams(new PageParams(0, potentialAnalyticsIds.size()));
                        client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)dataFrameAnalyticsRequest, listeners.acquire(response -> {
                            this.dataFrameAnalytics = response.getResources().results();
                        }));
                    } else {
                        this.dataFrameAnalytics = List.of();
                    }
                }
            }

            private ActionListener<GetTrainedModelsAction.Response> newRestListener(RestChannel channel) {
                return new RestResponseListener<GetTrainedModelsAction.Response>(channel){

                    public RestResponse buildResponse(GetTrainedModelsAction.Response trainedModels) throws Exception {
                        return RestTable.buildResponse((Table)RestCatTrainedModelsAction.this.buildTable(restRequest, trainedModelsStats, trainedModels.getResources().results(), dataFrameAnalytics), (RestChannel)this.channel);
                    }
                };
            }
        };
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/ml/trained_models\n");
        sb.append("/_cat/ml/trained_models/{model_id}\n");
    }

    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the trained model id").build());
        table.addCell((Object)"created_by", TableColumnAttributeBuilder.builder((String)"who created the model", (boolean)false).setAliases(new String[]{"c", "createdBy"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"heap_size", TableColumnAttributeBuilder.builder((String)"the estimated heap size to keep the model in memory").setAliases(new String[]{"hs", "modelHeapSize"}).build());
        table.addCell((Object)"operations", TableColumnAttributeBuilder.builder((String)"the estimated number of operations to use the model").setAliases(new String[]{"o", "modelOperations"}).build());
        table.addCell((Object)"license", TableColumnAttributeBuilder.builder((String)"The license level of the model", (boolean)false).setAliases(new String[]{"l"}).build());
        table.addCell((Object)"create_time", TableColumnAttributeBuilder.builder((String)"The time the model was created").setAliases(new String[]{"ct"}).build());
        table.addCell((Object)"version", TableColumnAttributeBuilder.builder((String)"The version of Elasticsearch when the model was created", (boolean)false).setAliases(new String[]{"v"}).build());
        table.addCell((Object)"description", TableColumnAttributeBuilder.builder((String)"The model description", (boolean)false).setAliases(new String[]{"d"}).build());
        table.addCell((Object)"type", TableColumnAttributeBuilder.builder((String)"The model type").setAliases(new String[]{"t"}).build());
        table.addCell((Object)"ingest.pipelines", TableColumnAttributeBuilder.builder((String)"The number of pipelines referencing the model").setAliases(new String[]{"ip", "ingestPipelines"}).build());
        table.addCell((Object)"ingest.count", TableColumnAttributeBuilder.builder((String)"The total number of docs processed by the model", (boolean)false).setAliases(new String[]{"ic", "ingestCount"}).build());
        table.addCell((Object)"ingest.time", TableColumnAttributeBuilder.builder((String)"The total time spent processing docs with this model", (boolean)false).setAliases(new String[]{"it", "ingestTime"}).build());
        table.addCell((Object)"ingest.current", TableColumnAttributeBuilder.builder((String)"The total documents currently being handled by the model", (boolean)false).setAliases(new String[]{"icurr", "ingestCurrent"}).build());
        table.addCell((Object)"ingest.failed", TableColumnAttributeBuilder.builder((String)"The total count of failed ingest attempts with this model", (boolean)false).setAliases(new String[]{"if", "ingestFailed"}).build());
        table.addCell((Object)"data_frame.id", TableColumnAttributeBuilder.builder((String)"The data frame analytics config id that created the model (if still available)").setAliases(new String[]{"dfid", "dataFrameAnalytics"}).build());
        table.addCell((Object)"data_frame.create_time", TableColumnAttributeBuilder.builder((String)"The time the data frame analytics config was created", (boolean)false).setAliases(new String[]{"dft", "dataFrameAnalyticsTime"}).build());
        table.addCell((Object)"data_frame.source_index", TableColumnAttributeBuilder.builder((String)"The source index used to train in the data frame analysis", (boolean)false).setAliases(new String[]{"dfsi", "dataFrameAnalyticsSrcIndex"}).build());
        table.addCell((Object)"data_frame.analysis", TableColumnAttributeBuilder.builder((String)"The analysis used by the data frame to build the model", (boolean)false).setAliases(new String[]{"dfa", "dataFrameAnalyticsAnalysis"}).build());
        table.endHeaders();
        return table;
    }

    Table buildTable(RestRequest request, List<GetTrainedModelsStatsAction.Response.TrainedModelStats> stats, List<TrainedModelConfig> configs, List<DataFrameAnalyticsConfig> analyticsConfigs) {
        Table table = this.getTableWithHeader(request);
        Map analyticsMap = analyticsConfigs.stream().collect(Collectors.toMap(DataFrameAnalyticsConfig::getId, Function.identity()));
        Map<String, AccumulatedStats> accumulatedStatsMap = stats.stream().filter(Objects::nonNull).collect(Collectors.toMap(GetTrainedModelsStatsAction.Response.TrainedModelStats::getModelId, AccumulatedStats::of, AccumulatedStats::merge));
        assert (configs.size() == accumulatedStatsMap.size());
        configs.forEach(config -> {
            table.startRow();
            table.addCell((Object)config.getModelId());
            table.addCell((Object)config.getCreatedBy());
            table.addCell((Object)ByteSizeValue.ofBytes((long)config.getModelSize()));
            table.addCell((Object)config.getEstimatedOperations());
            table.addCell((Object)config.getLicenseLevel());
            table.addCell((Object)config.getCreateTime());
            table.addCell((Object)config.getVersion().toString());
            table.addCell((Object)config.getDescription());
            table.addCell((Object)config.getModelType());
            AccumulatedStats accumulatedStats = Objects.requireNonNullElse((AccumulatedStats)accumulatedStatsMap.get(config.getModelId()), AccumulatedStats.EMPTY);
            table.addCell((Object)accumulatedStats.pipelineCount);
            table.addCell((Object)accumulatedStats.ingestStats.totalStats().ingestCount());
            table.addCell((Object)accumulatedStats.ingestStats.totalStats().ingestTimeInMillis());
            table.addCell((Object)accumulatedStats.ingestStats.totalStats().ingestCurrent());
            table.addCell((Object)accumulatedStats.ingestStats.totalStats().ingestFailedCount());
            DataFrameAnalyticsConfig dataFrameAnalyticsConfig = config.getTags().stream().filter(analyticsMap::containsKey).map(analyticsMap::get).findFirst().orElse(null);
            table.addCell((Object)(dataFrameAnalyticsConfig == null ? "__none__" : dataFrameAnalyticsConfig.getId()));
            table.addCell((Object)(dataFrameAnalyticsConfig == null ? null : dataFrameAnalyticsConfig.getCreateTime()));
            table.addCell(dataFrameAnalyticsConfig == null ? null : Strings.arrayToCommaDelimitedString((Object[])dataFrameAnalyticsConfig.getSource().getIndex()));
            DataFrameAnalysis analysis = dataFrameAnalyticsConfig == null ? null : dataFrameAnalyticsConfig.getAnalysis();
            table.addCell((Object)(analysis == null ? null : analysis.getWriteableName()));
            table.endRow();
        });
        return table;
    }

    private record AccumulatedStats(int pipelineCount, IngestStats ingestStats) {
        public static final AccumulatedStats EMPTY = AccumulatedStats.of(null);

        public static AccumulatedStats of(@Nullable GetTrainedModelsStatsAction.Response.TrainedModelStats stats) {
            return new AccumulatedStats(stats == null ? 0 : stats.getPipelineCount(), AccumulatedStats.getIngestStats(stats));
        }

        private static IngestStats getIngestStats(@Nullable GetTrainedModelsStatsAction.Response.TrainedModelStats stats) {
            if (stats == null) {
                return IngestStats.IDENTITY;
            }
            return stats.getIngestStats() == null ? IngestStats.IDENTITY : stats.getIngestStats();
        }

        public static AccumulatedStats merge(AccumulatedStats first, AccumulatedStats second) {
            return new AccumulatedStats(first.pipelineCount + second.pipelineCount, IngestStats.merge((IngestStats)first.ingestStats, (IngestStats)second.ingestStats));
        }
    }
}

