/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.index.RemoteClusterResolver;
import org.elasticsearch.xpack.sql.SqlInfoTransportAction;
import org.elasticsearch.xpack.sql.SqlUsageTransportAction;
import org.elasticsearch.xpack.sql.action.SqlClearCursorAction;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncDeleteResultsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlTranslateAction;
import org.elasticsearch.xpack.sql.plugin.SqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.SqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.SqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlTranslateAction;
import org.elasticsearch.xpack.sql.type.SqlDataTypeRegistry;

public class SqlPlugin
extends Plugin
implements ActionPlugin {
    private final LicensedFeature.Momentary JDBC_FEATURE = LicensedFeature.momentary((String)"sql", (String)"jdbc", (License.OperationMode)License.OperationMode.PLATINUM);
    private final LicensedFeature.Momentary ODBC_FEATURE = LicensedFeature.momentary((String)"sql", (String)"odbc", (License.OperationMode)License.OperationMode.PLATINUM);
    private final SqlLicenseChecker sqlLicenseChecker = new SqlLicenseChecker(mode -> {
        XPackLicenseState licenseState = this.getLicenseState();
        switch (mode) {
            case JDBC: {
                if (this.JDBC_FEATURE.check(licenseState)) break;
                throw LicenseUtils.newComplianceException((String)"jdbc");
            }
            case ODBC: {
                if (this.ODBC_FEATURE.check(licenseState)) break;
                throw LicenseUtils.newComplianceException((String)"odbc");
            }
            case PLAIN: 
            case CLI: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL mode " + String.valueOf(mode));
            }
        }
    });

    public SqlPlugin(Settings settings) {
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        return this.createComponents(services.client(), services.environment().settings(), services.clusterService().getClusterName().value(), services.linkedProjectConfigService(), services.namedWriteableRegistry());
    }

    Collection<Object> createComponents(Client client, Settings settings, String clusterName, LinkedProjectConfigService linkedProjectConfigService, NamedWriteableRegistry namedWriteableRegistry) {
        RemoteClusterResolver remoteClusterResolver = new RemoteClusterResolver(settings, linkedProjectConfigService);
        IndexResolver indexResolver = new IndexResolver(client, clusterName, SqlDataTypeRegistry.INSTANCE, () -> ((RemoteClusterResolver)remoteClusterResolver).remoteClusters());
        return Arrays.asList(this.sqlLicenseChecker, indexResolver, new PlanExecutor(client, indexResolver, namedWriteableRegistry));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{new RestSqlQueryAction(settings), new RestSqlTranslateAction(settings), new RestSqlClearCursorAction(), new RestSqlStatsAction(), new RestSqlAsyncGetResultsAction(), new RestSqlAsyncGetStatusAction(), new RestSqlAsyncDeleteResultsAction()});
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler(XPackUsageFeatureAction.SQL, SqlUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler(XPackInfoFeatureAction.SQL, SqlInfoTransportAction.class);
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)SqlQueryAction.INSTANCE, TransportSqlQueryAction.class), new ActionPlugin.ActionHandler((ActionType)SqlTranslateAction.INSTANCE, TransportSqlTranslateAction.class), new ActionPlugin.ActionHandler((ActionType)SqlClearCursorAction.INSTANCE, TransportSqlClearCursorAction.class), new ActionPlugin.ActionHandler((ActionType)SqlStatsAction.INSTANCE, TransportSqlStatsAction.class), new ActionPlugin.ActionHandler((ActionType)SqlAsyncGetResultsAction.INSTANCE, TransportSqlAsyncGetResultsAction.class), new ActionPlugin.ActionHandler((ActionType)SqlAsyncGetStatusAction.INSTANCE, TransportSqlAsyncGetStatusAction.class), usageAction, infoAction);
    }
}

