/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.execution.search.Querier;
import org.elasticsearch.xpack.sql.execution.search.SearchHitRowSet;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;
import org.elasticsearch.xpack.sql.util.Check;

public class SearchHitCursor
implements Cursor {
    private static final Logger log = LogManager.getLogger(SearchHitCursor.class);
    public static final String NAME = "h";
    private final SearchSourceBuilder nextQuery;
    private final List<HitExtractor> extractors;
    private final BitSet mask;
    private final int limit;
    private final boolean includeFrozen;
    private final boolean allowPartialSearchResults;

    SearchHitCursor(SearchSourceBuilder nextQuery, List<HitExtractor> exts, BitSet mask, int remainingLimit, boolean includeFrozen, boolean allowPartialSearchResults) {
        this.nextQuery = nextQuery;
        this.extractors = exts;
        this.mask = mask;
        this.limit = remainingLimit;
        this.includeFrozen = includeFrozen;
        this.allowPartialSearchResults = allowPartialSearchResults;
    }

    public SearchHitCursor(StreamInput in) throws IOException {
        this.nextQuery = new SearchSourceBuilder(in);
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableCollectionAsList(HitExtractor.class);
        this.mask = BitSet.valueOf(in.readByteArray());
        this.includeFrozen = in.readBoolean();
        this.allowPartialSearchResults = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.nextQuery.writeTo(out);
        out.writeVInt(this.limit);
        out.writeNamedWriteableCollection(this.extractors);
        out.writeByteArray(this.mask.toByteArray());
        out.writeBoolean(this.includeFrozen);
        out.writeBoolean(this.allowPartialSearchResults);
    }

    public String getWriteableName() {
        return NAME;
    }

    SearchSourceBuilder next() {
        return this.nextQuery;
    }

    BitSet mask() {
        return this.mask;
    }

    List<HitExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    boolean includeFrozen() {
        return this.includeFrozen;
    }

    boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Override
    public void nextPage(SqlConfiguration cfg, Client client, ActionListener<Cursor.Page> listener) {
        if (log.isTraceEnabled()) {
            log.trace("About to execute search hit query {}", (Object)StringUtils.toString((SearchSourceBuilder)this.nextQuery));
        }
        SearchRequest request = Querier.prepareRequest(this.nextQuery, cfg, false, this.includeFrozen, new String[0]);
        client.search(request, listener.delegateFailureAndWrap((l, response) -> SearchHitCursor.handle(client, response, request.source(), this.makeRowSet((SearchResponse)response), (ActionListener<Cursor.Page>)l, this.includeFrozen, this.allowPartialSearchResults)));
    }

    private Supplier<SearchHitRowSet> makeRowSet(SearchResponse response) {
        return () -> new SearchHitRowSet(this.extractors, this.mask, this.nextQuery.size(), this.limit, response);
    }

    static void handle(Client client, SearchResponse response, SearchSourceBuilder source, Supplier<SearchHitRowSet> makeRowSet, ActionListener<Cursor.Page> listener, boolean includeFrozen, boolean allowPartialSearchResults) {
        SearchHitRowSet rowSet;
        if (log.isTraceEnabled()) {
            Querier.logSearchResponse(response, log);
        }
        if (!(rowSet = makeRowSet.get()).hasRemaining()) {
            Querier.closePointInTime(client, response.pointInTimeId(), (ActionListener<Boolean>)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)Cursor.Page.last(rowSet))));
        } else {
            SearchHitCursor.updateSearchAfter(response.getHits().getHits(), source);
            SearchHitCursor nextCursor = new SearchHitCursor(source, rowSet.extractors(), rowSet.mask(), rowSet.getRemainingLimit(), includeFrozen, allowPartialSearchResults);
            listener.onResponse((Object)new Cursor.Page(rowSet, nextCursor));
        }
    }

    private static void updateSearchAfter(SearchHit[] hits, SearchSourceBuilder source) {
        SearchHit lastHit = hits[hits.length - 1];
        source.searchAfter(lastHit.getSortValues());
    }

    @Override
    public void clear(Client client, ActionListener<Boolean> listener) {
        Check.isTrue(this.nextQuery.pointInTimeBuilder() != null, "Expected cursor with point-in-time id but got null");
        Querier.closePointInTime(client, this.nextQuery.pointInTimeBuilder().getEncodedId(), listener);
    }

    public int hashCode() {
        return Objects.hash(this.nextQuery, this.extractors, this.limit, this.mask, this.includeFrozen, this.allowPartialSearchResults);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SearchHitCursor other = (SearchHitCursor)obj;
        return Objects.equals(this.nextQuery, other.nextQuery) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit) && Objects.equals(this.includeFrozen, other.includeFrozen) && Objects.equals(this.allowPartialSearchResults, other.allowPartialSearchResults);
    }
}

