/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AutoscalingCapacity
implements ToXContentObject,
Writeable {
    private final AutoscalingResources total;
    private final AutoscalingResources node;
    public static final AutoscalingCapacity ZERO = new AutoscalingCapacity(AutoscalingResources.ZERO, AutoscalingResources.ZERO);

    public AutoscalingCapacity(AutoscalingResources total, AutoscalingResources node) {
        assert (total != null) : "Cannot provide capacity without specifying total capacity";
        assert (node == null || node.memory == null || total.memory != null) : "Cannot provide node memory without total memory";
        assert (node == null || node.storage == null || total.storage != null) : "Cannot provide node storage without total storage";
        assert (node == null || node.processors == null || total.processors != null) : "Cannot provide node processors without total processors";
        this.total = total;
        this.node = node;
    }

    public AutoscalingCapacity(StreamInput in) throws IOException {
        this.total = new AutoscalingResources(in);
        this.node = (AutoscalingResources)in.readOptionalWriteable(AutoscalingResources::new);
    }

    public AutoscalingResources total() {
        return this.total;
    }

    public AutoscalingResources node() {
        return this.node;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.total.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.node);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.node != null) {
            builder.field("node", (ToXContent)this.node);
        }
        builder.field("total", (ToXContent)this.total);
        builder.endObject();
        return builder;
    }

    public static AutoscalingCapacity upperBound(AutoscalingCapacity c1, AutoscalingCapacity c2) {
        return new AutoscalingCapacity(AutoscalingResources.max(c1.total, c2.total), AutoscalingResources.max(c1.node, c2.node));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingCapacity capacity = (AutoscalingCapacity)o;
        return this.total.equals(capacity.total) && Objects.equals(this.node, capacity.node);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.node);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class AutoscalingResources
    implements ToXContentObject,
    Writeable {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        private final Processors processors;
        public static final AutoscalingResources ZERO = new AutoscalingResources(ByteSizeValue.ZERO, ByteSizeValue.ZERO, Processors.ZERO);

        public AutoscalingResources(ByteSizeValue storage, ByteSizeValue memory, Processors processors) {
            assert (storage != null || memory != null || processors != null);
            this.storage = storage;
            this.memory = memory;
            this.processors = processors;
        }

        public AutoscalingResources(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.processors = (Processors)in.readOptionalWriteable(Processors::readFrom);
        }

        @Nullable
        public ByteSizeValue storage() {
            return this.storage;
        }

        @Nullable
        public ByteSizeValue memory() {
            return this.memory;
        }

        @Nullable
        public Processors processors() {
            return this.processors;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.storage != null) {
                builder.field("storage", this.storage.getBytes());
            }
            if (this.memory != null) {
                builder.field("memory", this.memory.getBytes());
            }
            if (this.processors != null) {
                builder.field("processors", (ToXContent)this.processors);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
            out.writeOptionalWriteable((Writeable)this.processors);
        }

        public static AutoscalingResources max(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.max(sm1.storage, sm2.storage), AutoscalingResources.max(sm1.memory, sm2.memory), AutoscalingResources.max(sm1.processors, sm2.processors));
        }

        public static AutoscalingResources sum(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.add(sm1.storage, sm2.storage), AutoscalingResources.add(sm1.memory, sm2.memory), AutoscalingResources.add(sm1.processors, sm2.processors));
        }

        private static ByteSizeValue max(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.compareTo(v2) < 0 ? v2 : v1;
        }

        private static ByteSizeValue add(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return ByteSizeValue.ofBytes((long)(v1.getBytes() + v2.getBytes()));
        }

        private static Processors max(Processors v1, Processors v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.compareTo(v2) < 0 ? v2 : v1;
        }

        private static Processors add(Processors v1, Processors v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.plus(v2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoscalingResources that = (AutoscalingResources)o;
            return Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory) && Objects.equals(this.processors, that.processors);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory, this.processors);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Builder {
        private AutoscalingResources total;
        private AutoscalingResources node;

        public Builder capacity(AutoscalingCapacity capacity) {
            this.total = capacity.total;
            this.node = capacity.node;
            return this;
        }

        public Builder total(Long storage, Long memory, Double processors) {
            return this.total(this.byteSizeValue(storage), this.byteSizeValue(memory), Processors.of((Double)processors));
        }

        public Builder total(ByteSizeValue storage, ByteSizeValue memory, Processors processors) {
            return this.total(new AutoscalingResources(storage, memory, processors));
        }

        public Builder total(AutoscalingResources total) {
            this.total = total;
            return this;
        }

        public Builder node(Long storage, Long memory, Double processors) {
            return this.node(this.byteSizeValue(storage), this.byteSizeValue(memory), Processors.of((Double)processors));
        }

        public Builder node(ByteSizeValue storage, ByteSizeValue memory, Processors processors) {
            return this.node(new AutoscalingResources(storage, memory, processors));
        }

        public Builder node(AutoscalingResources node) {
            this.node = node;
            return this;
        }

        public AutoscalingCapacity build() {
            return new AutoscalingCapacity(this.total, this.node);
        }

        private ByteSizeValue byteSizeValue(Long memory) {
            return memory == null ? null : ByteSizeValue.ofBytes((long)memory);
        }
    }
}

