/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.RetryingInputStream;
import org.elasticsearch.repositories.blobstore.RequestedRangeNotSatisfiedException;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3BlobStore;
import org.elasticsearch.rest.RestStatus;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

class S3RetryingInputStream
extends RetryingInputStream {
    private static final Logger logger = LogManager.getLogger(S3RetryingInputStream.class);

    S3RetryingInputStream(OperationPurpose purpose, S3BlobStore blobStore, String blobKey) throws IOException {
        this(purpose, blobStore, blobKey, 0L, 0x7FFFFFFFFFFFFFFEL);
    }

    S3RetryingInputStream(OperationPurpose purpose, S3BlobStore blobStore, String blobKey, long start, long end) throws IOException {
        super((RetryingInputStream.BlobStoreServices)new S3BlobStoreServices(blobStore, blobKey, purpose), purpose, start, end);
    }

    private static long getStreamLength(GetObjectResponse getObjectResponse, long expectedStart, long expectedEnd) {
        try {
            return S3RetryingInputStream.tryGetStreamLength(getObjectResponse, expectedStart, expectedEnd);
        }
        catch (Exception e) {
            assert (false) : e;
            return 0x7FFFFFFFFFFFFFFEL;
        }
    }

    private static long tryGetStreamLength(GetObjectResponse getObjectResponse, long expectedStart, long expectedEnd) {
        String rangeString = getObjectResponse.contentRange();
        if (rangeString != null) {
            if (!rangeString.startsWith("bytes ")) {
                throw new IllegalArgumentException("unexpected Content-range header [" + rangeString + "], should have started with [bytes ]");
            }
            int hyphenPos = rangeString.indexOf(45);
            if (hyphenPos == -1) {
                throw new IllegalArgumentException("could not parse Content-range header [" + rangeString + "], missing hyphen");
            }
            int slashPos = rangeString.indexOf(47);
            if (slashPos == -1) {
                throw new IllegalArgumentException("could not parse Content-range header [" + rangeString + "], missing slash");
            }
            long rangeStart = Long.parseLong(rangeString, "bytes ".length(), hyphenPos, 10);
            long rangeEnd = Long.parseLong(rangeString, hyphenPos + 1, slashPos, 10);
            if (rangeEnd < rangeStart) {
                throw new IllegalArgumentException("invalid Content-range header [" + rangeString + "]");
            }
            if (rangeStart != expectedStart) {
                throw new IllegalArgumentException("unexpected Content-range header [" + rangeString + "], should have started at " + expectedStart);
            }
            if (rangeEnd > expectedEnd) {
                throw new IllegalArgumentException("unexpected Content-range header [" + rangeString + "], should have ended no later than " + expectedEnd);
            }
            return rangeEnd - rangeStart + 1L;
        }
        return getObjectResponse.contentLength();
    }

    boolean isEof() {
        return ((S3SingleAttemptInputStream)this.currentStream).isEof();
    }

    boolean isAborted() {
        return ((S3SingleAttemptInputStream)this.currentStream).isAborted();
    }

    long tryGetStreamLength(GetObjectResponse getObjectResponse) {
        return ((S3SingleAttemptInputStream)this.currentStream).tryGetStreamLength(getObjectResponse);
    }

    private record S3BlobStoreServices(S3BlobStore blobStore, String blobKey, OperationPurpose purpose) implements RetryingInputStream.BlobStoreServices
    {
        public S3SingleAttemptInputStream getInputStream(long start, long end) throws IOException {
            AmazonS3Reference clientReference = this.blobStore.clientReference();
            try {
                GetObjectRequest.Builder getObjectRequestBuilder = GetObjectRequest.builder().bucket(this.blobStore.bucket()).key(this.blobKey);
                S3BlobStore.configureRequestForMetrics((AwsRequest.Builder)getObjectRequestBuilder, this.blobStore, S3BlobStore.Operation.GET_OBJECT, this.purpose);
                if (start > 0L || end < 0x7FFFFFFFFFFFFFFEL) {
                    assert (start <= end) : "requesting beyond end, start = " + start + " end=" + end;
                    getObjectRequestBuilder.range("bytes=" + start + "-" + end);
                }
                GetObjectRequest getObjectRequest = (GetObjectRequest)getObjectRequestBuilder.build();
                ResponseInputStream getObjectResponse = clientReference.client().getObject(getObjectRequest);
                S3SingleAttemptInputStream s3SingleAttemptInputStream = new S3SingleAttemptInputStream((ResponseInputStream<GetObjectResponse>)getObjectResponse, start, end);
                if (clientReference != null) {
                    clientReference.close();
                }
                return s3SingleAttemptInputStream;
            }
            catch (Throwable getObjectRequestBuilder) {
                try {
                    if (clientReference != null) {
                        try {
                            clientReference.close();
                        }
                        catch (Throwable throwable) {
                            getObjectRequestBuilder.addSuppressed(throwable);
                        }
                    }
                    throw getObjectRequestBuilder;
                }
                catch (SdkException e) {
                    if (e instanceof SdkServiceException) {
                        SdkServiceException sdkServiceException = (SdkServiceException)((Object)e);
                        if (sdkServiceException.statusCode() == RestStatus.NOT_FOUND.getStatus()) {
                            throw new NoSuchFileException("Blob object [" + this.blobKey + "] not found: " + sdkServiceException.getMessage());
                        }
                        if (sdkServiceException.statusCode() == RestStatus.REQUESTED_RANGE_NOT_SATISFIED.getStatus()) {
                            throw new RequestedRangeNotSatisfiedException(this.blobKey, start, end < 0x7FFFFFFFFFFFFFFEL ? end - start + 1L : end, (Throwable)sdkServiceException);
                        }
                    }
                    throw e;
                }
            }
        }

        public void onRetryStarted(String action) {
            this.blobStore.getS3RepositoriesMetrics().retryStartedCounter().incrementBy(1L, this.metricAttributes(action));
        }

        public void onRetrySucceeded(String action, long numberOfRetries) {
            Map<String, Object> attributes = this.metricAttributes(action);
            this.blobStore.getS3RepositoriesMetrics().retryCompletedCounter().incrementBy(1L, attributes);
            this.blobStore.getS3RepositoriesMetrics().retryHistogram().record(numberOfRetries, attributes);
        }

        public long getMeaningfulProgressSize() {
            return Math.max(1L, this.blobStore.bufferSizeInBytes() / 100L);
        }

        public int getMaxRetries() {
            return this.blobStore.getMaxRetries();
        }

        public String getBlobDescription() {
            return this.blobStore.bucket() + "/" + this.blobKey;
        }

        private Map<String, Object> metricAttributes(String action) {
            return Map.of("repo_type", "s3", "repo_name", this.blobStore.getRepositoryMetadata().name(), "operation", S3BlobStore.Operation.GET_OBJECT.getKey(), "purpose", this.purpose.getKey(), "action", action);
        }
    }

    private static class S3SingleAttemptInputStream
    extends RetryingInputStream.SingleAttemptInputStream {
        private final ResponseInputStream<GetObjectResponse> responseStream;
        private final long start;
        private final long end;
        private final long lastOffset;
        private long offset = 0L;
        private boolean closed;
        private boolean eof;
        private boolean aborted;

        private S3SingleAttemptInputStream(ResponseInputStream<GetObjectResponse> responseStream, long start, long end) {
            this.responseStream = responseStream;
            this.start = start;
            this.end = end;
            this.lastOffset = S3RetryingInputStream.getStreamLength((GetObjectResponse)responseStream.response(), start, end);
        }

        public int read() throws IOException {
            this.ensureOpen();
            int result = this.responseStream.read();
            if (result == -1) {
                this.eof = true;
            } else {
                ++this.offset;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            int bytesRead = this.responseStream.read(b, off, len);
            if (bytesRead == -1) {
                this.eof = true;
            } else {
                this.offset += (long)bytesRead;
            }
            return bytesRead;
        }

        private void ensureOpen() {
            if (this.closed) {
                String message = "using " + ((Object)((Object)this)).getClass().getSimpleName() + " after close";
                assert (false) : message;
                throw new IllegalStateException(message);
            }
        }

        public void close() throws IOException {
            this.maybeAbort(this.responseStream);
            try {
                this.responseStream.close();
            }
            finally {
                this.closed = true;
            }
        }

        private void maybeAbort(ResponseInputStream<?> stream) {
            if (this.isEof()) {
                return;
            }
            try {
                if (this.offset < this.lastOffset) {
                    stream.abort();
                    this.aborted = true;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to abort stream before closing", (Throwable)e);
            }
        }

        public long skip(long n) throws IOException {
            return super.skip(n);
        }

        public void reset() {
            throw new UnsupportedOperationException("S3InputStream does not support seeking");
        }

        private boolean isEof() {
            return this.eof || this.offset == this.lastOffset;
        }

        private boolean isAborted() {
            return this.aborted;
        }

        private long tryGetStreamLength(GetObjectResponse response) {
            return S3RetryingInputStream.tryGetStreamLength(response, this.start, this.end);
        }

        protected long getFirstOffset() {
            return this.start;
        }
    }
}

