/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.index.fielddata.LeafHistogramFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromBinaryBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.DoublesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.LongsBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tdigest.parsing.TDigestParser;
import org.elasticsearch.xcontent.CopyingXContentParser;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;
import org.elasticsearch.xpack.analytics.mapper.TDigestBlockLoader;

public class TDigestFieldMapper
extends FieldMapper {
    public static final FeatureFlag TDIGEST_FIELD_MAPPER = new FeatureFlag("tdigest_field_mapper");
    public static final String CENTROIDS_NAME = "centroids";
    public static final String COUNTS_NAME = "counts";
    public static final String SUM_FIELD_NAME = "sum";
    public static final String MIN_FIELD_NAME = "min";
    public static final String MAX_FIELD_NAME = "max";
    public static final String CONTENT_TYPE = "tdigest";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())), TDigestFieldMapper.notInMultiFields((String)"tdigest"));
    private final Explicit<Boolean> ignoreMalformed;
    private final boolean ignoreMalformedByDefault;
    private final TDigestState.Type digestType;
    private final double compression;

    private static TDigestFieldMapper toType(FieldMapper in) {
        return (TDigestFieldMapper)in;
    }

    public TDigestFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
        this.digestType = (TDigestState.Type)builder.digestType.getValue();
        this.compression = (Double)builder.compression.getValue();
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    public TDigestState.Type digestType() {
        return this.digestType;
    }

    public double compression() {
        return this.compression;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreMalformedByDefault).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        context.path().add(this.leafName());
        boolean shouldStoreMalformedDataForSyntheticSource = context.mappingLookup().isSourceSynthetic() && this.ignoreMalformed();
        XContentSubParser subParser = null;
        XContentBuilder malformedDataForSyntheticSource = null;
        try {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            if (shouldStoreMalformedDataForSyntheticSource) {
                CopyingXContentParser copyingParser = new CopyingXContentParser(context.parser());
                malformedDataForSyntheticSource = copyingParser.getBuilder();
                subParser = new XContentSubParser((XContentParser)copyingParser);
            } else {
                subParser = new XContentSubParser(context.parser());
            }
            subParser.nextToken();
            TDigestParser.ParsedTDigest parsedTDigest = TDigestParser.parse((String)this.fullPath(), (XContentParser)subParser, DocumentParsingException::new, XContentParserUtils::parsingException);
            BytesRef docValue = TDigestFieldMapper.encodeCentroidsAndCounts(parsedTDigest.centroids(), parsedTDigest.counts());
            BinaryDocValuesField digestField = new BinaryDocValuesField(this.fullPath(), docValue);
            NumericDocValuesField maxField = null;
            if (!Double.isNaN(parsedTDigest.max())) {
                maxField = new NumericDocValuesField(TDigestFieldMapper.valuesMaxSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)parsedTDigest.max()));
            }
            NumericDocValuesField minField = null;
            if (!Double.isNaN(parsedTDigest.min())) {
                minField = new NumericDocValuesField(TDigestFieldMapper.valuesMinSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)parsedTDigest.min()));
            }
            NumericDocValuesField countField = new NumericDocValuesField(TDigestFieldMapper.valuesCountSubFieldName(this.fullPath()), parsedTDigest.count());
            NumericDocValuesField sumField = null;
            if (!Double.isNaN(parsedTDigest.sum())) {
                sumField = new NumericDocValuesField(TDigestFieldMapper.valuesSumSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)parsedTDigest.sum()));
            }
            if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
            }
            context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)digestField);
            context.doc().add((IndexableField)countField);
            if (sumField != null) {
                context.doc().add((IndexableField)sumField);
            }
            if (maxField != null) {
                context.doc().add((IndexableField)maxField);
            }
            if (minField != null) {
                context.doc().add((IndexableField)minField);
            }
        }
        catch (Exception ex) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.fieldType().typeName() + "]", ex);
            }
            if (subParser != null) {
                subParser.close();
            } else if (shouldStoreMalformedDataForSyntheticSource) {
                malformedDataForSyntheticSource = XContentBuilder.builder((XContent)context.parser().contentType().xContent()).copyCurrentStructure(context.parser());
            }
            if (malformedDataForSyntheticSource != null) {
                context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField((String)this.fullPath(), malformedDataForSyntheticSource));
            }
            context.addIgnoredField(this.fieldType().name());
        }
        context.path().remove();
    }

    private static BytesRef encodeCentroidsAndCounts(List<Double> centroids, List<Long> counts) throws IOException {
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        for (int i = 0; i < centroids.size(); ++i) {
            long count = counts.get(i);
            assert (count >= 0L);
            if (count <= 0L) continue;
            streamOutput.writeVLong(count);
            streamOutput.writeDouble(centroids.get(i).doubleValue());
        }
        BytesRef docValue = streamOutput.bytes().toBytesRef();
        return docValue;
    }

    private static String valuesCountSubFieldName(String fullPath) {
        return fullPath + "._values_count";
    }

    private static String valuesSumSubFieldName(String fullPath) {
        return fullPath + "._values_sum";
    }

    private static String valuesMinSubFieldName(String fullPath) {
        return fullPath + "._values_min";
    }

    private static String valuesMaxSubFieldName(String fullPath) {
        return fullPath + "._values_max";
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new TDigestSyntheticFieldLoader(), new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath())}));
    }

    public static class Builder
    extends FieldMapper.Builder {
        private static final double DEFAULT_COMPRESSION = 100.0;
        private static final double MAXIMUM_COMPRESSION = 10000.0;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<TDigestState.Type> digestType;
        private final FieldMapper.Parameter<Double> compression;

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> TDigestFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
            this.digestType = FieldMapper.Parameter.enumParam((String)"digest_type", (boolean)false, m -> TDigestFieldMapper.toType((FieldMapper)m).digestType, (Enum)TDigestState.Type.HYBRID, TDigestState.Type.class);
            this.compression = new FieldMapper.Parameter("compression", false, () -> 100.0, (n, c1, o) -> XContentMapValues.nodeDoubleValue((Object)o), m -> TDigestFieldMapper.toType((FieldMapper)m).compression, XContentBuilder::field, Objects::toString).addValidator(c -> {
                if (c <= 0.0 || c > 10000.0) {
                    throw new IllegalArgumentException("compression must be a positive integer between 1 and 10000.0 was [" + c + "]");
                }
            });
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.digestType, this.compression, this.ignoreMalformed, this.meta};
        }

        public TDigestFieldMapper build(MapperBuilderContext context) {
            return new TDigestFieldMapper(this.leafName(), new TDigestFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    private class TDigestSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        private final InternalTDigestValue value = new InternalTDigestValue();
        private BytesRef binaryValue;
        private double min;
        private double max;
        private double sum;

        private TDigestSyntheticFieldLoader() {
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            BinaryDocValues docValues = leafReader.getBinaryDocValues(TDigestFieldMapper.this.fieldType().name());
            NumericDocValues minValues = leafReader.getNumericDocValues(TDigestFieldMapper.valuesMinSubFieldName(TDigestFieldMapper.this.fullPath()));
            NumericDocValues maxValues = leafReader.getNumericDocValues(TDigestFieldMapper.valuesMaxSubFieldName(TDigestFieldMapper.this.fullPath()));
            NumericDocValues sumValues = leafReader.getNumericDocValues(TDigestFieldMapper.valuesSumSubFieldName(TDigestFieldMapper.this.fullPath()));
            if (docValues == null) {
                this.binaryValue = null;
                return null;
            }
            return docId -> {
                if (docValues.advanceExact(docId)) {
                    if (minValues != null) {
                        minValues.advanceExact(docId);
                        this.min = NumericUtils.sortableLongToDouble((long)minValues.longValue());
                    } else {
                        this.min = Double.NaN;
                    }
                    if (maxValues != null) {
                        maxValues.advanceExact(docId);
                        this.max = NumericUtils.sortableLongToDouble((long)maxValues.longValue());
                    } else {
                        this.max = Double.NaN;
                    }
                    if (sumValues != null) {
                        sumValues.advanceExact(docId);
                        this.sum = NumericUtils.sortableLongToDouble((long)sumValues.longValue());
                    } else {
                        this.sum = Double.NaN;
                    }
                    this.binaryValue = docValues.binaryValue();
                    return true;
                }
                this.binaryValue = null;
                return false;
            };
        }

        public boolean hasValue() {
            return this.binaryValue != null;
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.binaryValue == null) {
                return;
            }
            this.value.reset(this.binaryValue);
            b.startObject();
            if (!Double.isNaN(this.min)) {
                b.field(TDigestFieldMapper.MIN_FIELD_NAME, this.min);
            }
            if (!Double.isNaN(this.max)) {
                b.field(TDigestFieldMapper.MAX_FIELD_NAME, this.max);
            }
            if (!Double.isNaN(this.sum)) {
                b.field(TDigestFieldMapper.SUM_FIELD_NAME, this.sum);
            }
            b.startArray(TDigestFieldMapper.CENTROIDS_NAME);
            while (this.value.next()) {
                b.value(this.value.value());
            }
            b.endArray();
            this.value.reset(this.binaryValue);
            b.startArray(TDigestFieldMapper.COUNTS_NAME);
            while (this.value.next()) {
                b.value(this.value.count());
            }
            b.endArray();
            b.endObject();
        }

        public String fieldName() {
            return TDigestFieldMapper.this.fullPath();
        }

        public long valueCount() {
            return this.binaryValue != null ? 1L : 0L;
        }
    }

    static class InternalTDigestValue
    extends HistogramValue {
        double value;
        long count;
        boolean isExhausted;
        final ByteArrayStreamInput streamInput = new ByteArrayStreamInput();

        InternalTDigestValue() {
        }

        void reset(BytesRef bytesRef) throws IOException {
            this.streamInput.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            this.isExhausted = false;
            this.value = 0.0;
            this.count = 0L;
        }

        public boolean next() throws IOException {
            if (this.streamInput.available() > 0) {
                this.count = this.streamInput.readVLong();
                this.value = this.streamInput.readDouble();
                return true;
            }
            this.isExhausted = true;
            return false;
        }

        public double value() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.value;
        }

        public long count() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.count;
        }
    }

    public static class TDigestFieldType
    extends MappedFieldType {
        public TDigestFieldType(String name, Map<String, String> meta) {
            super(name, IndexType.docValuesOnly(), false, meta);
        }

        public String typeName() {
            return TDigestFieldMapper.CONTENT_TYPE;
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            DoublesBlockLoader minimaLoader = new DoublesBlockLoader(TDigestFieldMapper.valuesMinSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            DoublesBlockLoader maximaLoader = new DoublesBlockLoader(TDigestFieldMapper.valuesMaxSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            DoublesBlockLoader sumsLoader = new DoublesBlockLoader(TDigestFieldMapper.valuesSumSubFieldName(this.name()), NumericUtils::sortableLongToDouble);
            LongsBlockLoader valueCountsLoader = new LongsBlockLoader(TDigestFieldMapper.valuesCountSubFieldName(this.name()));
            BytesRefsFromBinaryBlockLoader digestLoader = new BytesRefsFromBinaryBlockLoader(this.name());
            return new TDigestBlockLoader(digestLoader, minimaLoader, maximaLoader, sumsLoader, valueCountsLoader);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public boolean isSearchable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new IndexHistogramFieldData(this, this.name(), AnalyticsValuesSourceType.HISTOGRAM){

                public LeafHistogramFieldData load(final LeafReaderContext context) {
                    return new LeafHistogramFieldData(){

                        public HistogramValues getHistogramValues() throws IOException {
                            try {
                                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)fieldName);
                                final InternalTDigestValue value = new InternalTDigestValue();
                                return new HistogramValues(this){

                                    public boolean advanceExact(int doc) throws IOException {
                                        return values.advanceExact(doc);
                                    }

                                    public HistogramValue histogram() throws IOException {
                                        try {
                                            value.reset(values.binaryValue());
                                            return value;
                                        }
                                        catch (IOException e) {
                                            throw new IOException("Cannot load doc value", e);
                                        }
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new IOException("Cannot load doc values", e);
                            }
                        }

                        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                            throw new UnsupportedOperationException("The [tdigest] field does not support scripts");
                        }

                        public FormattedDocValues getFormattedValues(DocValueFormat format) {
                            try {
                                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)fieldName);
                                final InternalTDigestValue value = new InternalTDigestValue();
                                return new FormattedDocValues(){

                                    public boolean advanceExact(int docId) throws IOException {
                                        return values.advanceExact(docId);
                                    }

                                    public int docValueCount() {
                                        return 1;
                                    }

                                    public Object nextValue() throws IOException {
                                        value.reset(values.binaryValue());
                                        return value;
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Unable to loead histogram doc values", e);
                            }
                        }

                        public SortedBinaryDocValues getBytesValues() {
                            throw new UnsupportedOperationException("String representation of doc values for [tdigest] fields is not supported");
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }
                    };
                }

                public LeafHistogramFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    throw new IllegalArgumentException("can't sort on the [tdigest] field");
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("can't sort on the [tdigest] field");
                }
            };
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[tdigest] field do not support searching, use dedicated aggregations instead: [" + this.name() + "]");
        }
    }
}

