/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.cumulativecardinality;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.cumulativecardinality.CumulativeCardinalityPipelineAggregator;

public class CumulativeCardinalityPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<CumulativeCardinalityPipelineAggregationBuilder> {
    public static final String NAME = "cumulative_cardinality";
    public static final ConstructingObjectParser<CumulativeCardinalityPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser("cumulative_cardinality", false, (args, name) -> new CumulativeCardinalityPipelineAggregationBuilder((String)name, (String)args[0]));
    private String format;

    public CumulativeCardinalityPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public CumulativeCardinalityPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
    }

    public CumulativeCardinalityPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new CumulativeCardinalityPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), metadata);
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addBucketPathValidationError("must contain a single entry for aggregation [" + this.name + "]");
        }
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(BUCKETS_PATH_FIELD.getPreferredName(), this.bucketsPaths[0]);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CumulativeCardinalityPipelineAggregationBuilder other = (CumulativeCardinalityPipelineAggregationBuilder)((Object)obj);
        return Objects.equals(this.format, other.format);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean overrideBucketsPath() {
        return true;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareString(CumulativeCardinalityPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
    }
}

