/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ProxyConfig;
import org.elasticsearch.xpack.sql.client.SslConfig;
import org.elasticsearch.xpack.sql.client.StringUtils;

public class ConnectionConfiguration {
    public static final String PROPERTIES_VALIDATION = "validate.properties";
    private static final String PROPERTIES_VALIDATION_DEFAULT = "true";
    public static final String BINARY_COMMUNICATION = "binary.format";
    private static final String BINARY_COMMUNICATION_DEFAULT = "true";
    public static final String CONNECT_TIMEOUT = "connect.timeout";
    private static final String CONNECT_TIMEOUT_DEFAULT = String.valueOf(TimeUnit.SECONDS.toMillis(30L));
    public static final String NETWORK_TIMEOUT = "network.timeout";
    private static final String NETWORK_TIMEOUT_DEFAULT = String.valueOf(TimeUnit.MINUTES.toMillis(1L));
    public static final String QUERY_TIMEOUT = "query.timeout";
    private static final String QUERY_TIMEOUT_DEFAULT = String.valueOf(TimeUnit.SECONDS.toMillis(90L));
    public static final String PAGE_TIMEOUT = "page.timeout";
    private static final String PAGE_TIMEOUT_DEFAULT = String.valueOf(TimeUnit.SECONDS.toMillis(45L));
    public static final String PAGE_SIZE = "page.size";
    private static final String PAGE_SIZE_DEFAULT = "1000";
    public static final String AUTH_USER = "user";
    public static final String AUTH_PASS = "password";
    private static final String CATALOG = "catalog";
    public static final String ALLOW_PARTIAL_SEARCH_RESULTS = "allow.partial.search.results";
    public static final String ALLOW_PARTIAL_SEARCH_RESULTS_DEFAULT = "false";
    public static final String PROJECT_ROUTING = "project.routing";
    protected static final Set<String> OPTION_NAMES = new LinkedHashSet<String>(Arrays.asList("validate.properties", "binary.format", "connect.timeout", "network.timeout", "query.timeout", "page.timeout", "page.size", "user", "password", "catalog", "allow.partial.search.results", "project.routing"));
    private final boolean validateProperties;
    private final boolean binaryCommunication;
    private final URI baseURI;
    private final String connectionString;
    private final long connectTimeout;
    private final long networkTimeout;
    private final long queryTimeout;
    private final long pageTimeout;
    private final int pageSize;
    private final String user;
    private final String pass;
    private final SslConfig sslConfig;
    private final ProxyConfig proxyConfig;
    private final boolean allowPartialSearchResults;
    private final String projectRouting;

    public ConnectionConfiguration(URI baseURI, String connectionString, Properties props) throws ClientException {
        this.connectionString = connectionString;
        Properties settings = props != null ? props : new Properties();
        this.validateProperties = this.parseValue(PROPERTIES_VALIDATION, settings.getProperty(PROPERTIES_VALIDATION, "true"), Boolean::parseBoolean);
        if (this.validateProperties) {
            ConnectionConfiguration.checkPropertyNames(settings, this.optionNames());
        }
        this.binaryCommunication = this.parseValue(BINARY_COMMUNICATION, settings.getProperty(BINARY_COMMUNICATION, "true"), Boolean::parseBoolean);
        this.connectTimeout = this.parseValue(CONNECT_TIMEOUT, settings.getProperty(CONNECT_TIMEOUT, CONNECT_TIMEOUT_DEFAULT), Long::parseLong);
        this.networkTimeout = this.parseValue(NETWORK_TIMEOUT, settings.getProperty(NETWORK_TIMEOUT, NETWORK_TIMEOUT_DEFAULT), Long::parseLong);
        this.queryTimeout = this.parseValue(QUERY_TIMEOUT, settings.getProperty(QUERY_TIMEOUT, QUERY_TIMEOUT_DEFAULT), Long::parseLong);
        this.pageTimeout = this.parseValue(PAGE_TIMEOUT, settings.getProperty(PAGE_TIMEOUT, PAGE_TIMEOUT_DEFAULT), Long::parseLong);
        this.pageSize = this.parseValue(PAGE_SIZE, settings.getProperty(PAGE_SIZE, PAGE_SIZE_DEFAULT), Integer::parseInt);
        this.user = settings.getProperty(AUTH_USER);
        this.pass = settings.getProperty(AUTH_PASS);
        this.sslConfig = new SslConfig(settings, baseURI);
        this.proxyConfig = new ProxyConfig(settings);
        this.baseURI = ConnectionConfiguration.normalizeSchema(baseURI, connectionString, this.sslConfig.isEnabled());
        this.allowPartialSearchResults = this.parseValue(ALLOW_PARTIAL_SEARCH_RESULTS, settings.getProperty(ALLOW_PARTIAL_SEARCH_RESULTS, ALLOW_PARTIAL_SEARCH_RESULTS_DEFAULT), Boolean::parseBoolean);
        this.projectRouting = settings.getProperty(PROJECT_ROUTING);
    }

    public ConnectionConfiguration(URI baseURI, String connectionString, boolean validateProperties, boolean binaryCommunication, long connectTimeout, long networkTimeout, long queryTimeout, long pageTimeout, int pageSize, String user, String pass, SslConfig sslConfig, ProxyConfig proxyConfig, boolean allowPartialSearchResults, String projectRouting) throws ClientException {
        this.validateProperties = validateProperties;
        this.binaryCommunication = binaryCommunication;
        this.connectionString = connectionString;
        this.connectTimeout = connectTimeout;
        this.networkTimeout = networkTimeout;
        this.queryTimeout = queryTimeout;
        this.pageTimeout = pageTimeout;
        this.pageSize = pageSize;
        this.user = user;
        this.pass = pass;
        this.sslConfig = sslConfig;
        this.proxyConfig = proxyConfig;
        this.baseURI = baseURI;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.projectRouting = projectRouting;
    }

    private static URI normalizeSchema(URI uri, String connectionString, boolean isSSLEnabled) {
        try {
            return new URI(isSSLEnabled ? "https" : "http", null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new ClientException("Cannot parse process baseURI [" + connectionString + "] " + ex.getMessage());
        }
    }

    protected Collection<String> optionNames() {
        TreeSet<String> options = new TreeSet<String>(OPTION_NAMES);
        options.addAll(this.extraOptions());
        return options;
    }

    protected Collection<String> extraOptions() {
        return Collections.emptyList();
    }

    private static void checkPropertyNames(Properties settings, Collection<String> knownNames) throws ClientException {
        Enumeration<?> pNames = settings.propertyNames();
        while (pNames.hasMoreElements()) {
            String message = ConnectionConfiguration.isKnownProperty(pNames.nextElement().toString(), knownNames);
            if (message == null) continue;
            throw new ClientException(message);
        }
    }

    private static String isKnownProperty(String propertyName, Collection<String> knownOptions) {
        if (knownOptions.contains(propertyName)) {
            return null;
        }
        return "Unknown parameter [" + propertyName + "]; did you mean " + StringUtils.findSimilar(propertyName, knownOptions);
    }

    protected <T> T parseValue(String key, String value, Function<String, T> parser) {
        try {
            return parser.apply(value);
        }
        catch (Exception ex) {
            throw new ClientException("Cannot parse property [" + key + "] with value [" + value + "]; " + ex.getMessage());
        }
    }

    protected boolean isSSLEnabled() {
        return this.sslConfig.isEnabled();
    }

    public boolean validateProperties() {
        return this.validateProperties;
    }

    public boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    public ProxyConfig proxyConfig() {
        return this.proxyConfig;
    }

    public long connectTimeout() {
        return this.connectTimeout;
    }

    public long networkTimeout() {
        return this.networkTimeout;
    }

    public long queryTimeout() {
        return this.queryTimeout;
    }

    public long pageTimeout() {
        return this.pageTimeout;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public String authUser() {
        return this.user;
    }

    public String authPass() {
        return this.pass;
    }

    public URI baseUri() {
        return this.baseURI;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public String projectRouting() {
        return this.projectRouting;
    }

    static {
        OPTION_NAMES.addAll(SslConfig.OPTION_NAMES);
        OPTION_NAMES.addAll(ProxyConfig.OPTION_NAMES);
    }
}

