/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.request.rarank;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record OpenShiftAIRerankRequestEntity(@Nullable String modelId, String query, List<String> documents, @Nullable Boolean returnDocuments, @Nullable Integer topN) implements ToXContentObject
{
    private static final String MODEL_FIELD = "model";
    private static final String DOCUMENTS_FIELD = "documents";
    private static final String QUERY_FIELD = "query";

    public OpenShiftAIRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_FIELD, this.modelId);
        }
        builder.field(QUERY_FIELD, this.query);
        builder.field(DOCUMENTS_FIELD, this.documents);
        if (this.topN != null) {
            builder.field("top_n", this.topN);
        }
        if (this.returnDocuments != null) {
            builder.field("return_documents", this.returnDocuments);
        }
        builder.endObject();
        return builder;
    }
}

