/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.embeddings;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.InferenceUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class OpenShiftAiEmbeddingsServiceSettings
extends OpenShiftAiServiceSettings {
    public static final String NAME = "openshift_ai_embeddings_service_settings";
    private final Integer dimensions;
    private final SimilarityMeasure similarity;
    private final Integer maxInputTokens;
    private final Boolean dimensionsSetByUser;

    public static OpenShiftAiEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        OpenShiftAiServiceSettings.OpenShiftAiCommonServiceSettings commonServiceSettings = OpenShiftAiEmbeddingsServiceSettings.extractOpenShiftAiCommonServiceSettings(map, context, validationException);
        Integer dimensions = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        Boolean dimensionsSetByUser = ServiceUtils.extractOptionalBoolean(map, "dimensions_set_by_user", validationException);
        switch (context) {
            case REQUEST: {
                if (dimensionsSetByUser != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError("dimensions_set_by_user", "service_settings"));
                }
                dimensionsSetByUser = dimensions != null;
                break;
            }
            case PERSISTENT: {
                if (dimensionsSetByUser != null) break;
                validationException.addValidationError(InferenceUtils.missingSettingErrorMsg((String)"dimensions_set_by_user", (String)"service_settings"));
            }
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenShiftAiEmbeddingsServiceSettings(commonServiceSettings.model(), commonServiceSettings.uri(), dimensions, similarity, maxInputTokens, commonServiceSettings.rateLimitSettings(), dimensionsSetByUser);
    }

    public OpenShiftAiEmbeddingsServiceSettings(StreamInput in) throws IOException {
        super(in);
        this.dimensions = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.maxInputTokens = in.readOptionalVInt();
        this.dimensionsSetByUser = in.readBoolean();
    }

    public OpenShiftAiEmbeddingsServiceSettings(@Nullable String modelId, URI uri, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings rateLimitSettings, Boolean dimensionsSetByUser) {
        super(modelId, uri, rateLimitSettings);
        this.dimensions = dimensions;
        this.similarity = similarity;
        this.maxInputTokens = maxInputTokens;
        this.dimensionsSetByUser = Objects.requireNonNull(dimensionsSetByUser);
    }

    public OpenShiftAiEmbeddingsServiceSettings(String modelId, String url, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings rateLimitSettings, Boolean dimensionsSetByUser) {
        this(modelId, ServiceUtils.createUri(url), dimensions, similarity, maxInputTokens, rateLimitSettings, dimensionsSetByUser);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeBoolean(this.dimensionsSetByUser.booleanValue());
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.toXContentFragmentOfExposedFields(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        builder.field("dimensions_set_by_user", this.dimensionsSetByUser);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenShiftAiEmbeddingsServiceSettings that = (OpenShiftAiEmbeddingsServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.dimensions, this.maxInputTokens, this.similarity, this.rateLimitSettings, this.dimensionsSetByUser);
    }
}

