/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIResponseHandler;
import org.elasticsearch.xpack.inference.services.jinaai.response.JinaAIRerankResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.openshiftai.action.OpenShiftAiActionVisitor;
import org.elasticsearch.xpack.inference.services.openshiftai.completion.OpenShiftAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.openshiftai.completion.OpenShiftAiCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openshiftai.embeddings.OpenShiftAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.openshiftai.embeddings.OpenShiftAiEmbeddingsResponseHandler;
import org.elasticsearch.xpack.inference.services.openshiftai.request.completion.OpenShiftAiChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openshiftai.request.embeddings.OpenShiftAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.openshiftai.request.rarank.OpenShiftAiRerankRequest;
import org.elasticsearch.xpack.inference.services.openshiftai.rerank.OpenShiftAiRerankModel;

public class OpenShiftAiActionCreator
implements OpenShiftAiActionVisitor {
    private static final String FAILED_TO_SEND_REQUEST_ERROR_MESSAGE = "Failed to send OpenShift AI %s request from inference entity id [%s]";
    private static final String COMPLETION_ERROR_PREFIX = "OpenShift AI completions";
    private static final String USER_ROLE = "user";
    private static final ResponseHandler EMBEDDINGS_HANDLER = new OpenShiftAiEmbeddingsResponseHandler("OpenShift AI text embedding", OpenAiEmbeddingsResponseEntity::fromResponse);
    private static final ResponseHandler COMPLETION_HANDLER = new OpenShiftAiCompletionResponseHandler("OpenShift AI completion", OpenAiChatCompletionResponseEntity::fromResponse);
    private static final ResponseHandler RERANK_HANDLER = new JinaAIResponseHandler("OpenShift AI rerank", (request, response) -> JinaAIRerankResponseEntity.fromResponse(response));
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public OpenShiftAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(OpenShiftAiEmbeddingsModel model) {
        GenericRequestManager<EmbeddingsInput> manager = new GenericRequestManager<EmbeddingsInput>(this.serviceComponents.threadPool(), model, EMBEDDINGS_HANDLER, embeddingsInput -> new OpenShiftAiEmbeddingsRequest(this.serviceComponents.truncator(), Truncator.truncate(embeddingsInput.getTextInputs(), model.getServiceSettings().maxInputTokens()), model), EmbeddingsInput.class);
        String errorMessage = OpenShiftAiActionCreator.buildErrorMessage(TaskType.TEXT_EMBEDDING, model.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, manager, errorMessage);
    }

    @Override
    public ExecutableAction create(OpenShiftAiChatCompletionModel model) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), model, COMPLETION_HANDLER, inputs -> new OpenShiftAiChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), model), ChatCompletionInput.class);
        String errorMessage = OpenShiftAiActionCreator.buildErrorMessage(TaskType.COMPLETION, model.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }

    @Override
    public ExecutableAction create(OpenShiftAiRerankModel model, Map<String, Object> taskSettings) {
        OpenShiftAiRerankModel overriddenModel = OpenShiftAiRerankModel.of(model, taskSettings);
        GenericRequestManager<QueryAndDocsInputs> manager = new GenericRequestManager<QueryAndDocsInputs>(this.serviceComponents.threadPool(), overriddenModel, RERANK_HANDLER, inputs -> new OpenShiftAiRerankRequest(inputs.getQuery(), inputs.getChunks(), inputs.getReturnDocuments(), inputs.getTopN(), overriddenModel), QueryAndDocsInputs.class);
        String errorMessage = OpenShiftAiActionCreator.buildErrorMessage(TaskType.RERANK, overriddenModel.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, manager, errorMessage);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)FAILED_TO_SEND_REQUEST_ERROR_MESSAGE, (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

