/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.request.rerank;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record NvidiaRerankRequestEntity(String modelId, String query, List<String> passages) implements ToXContentObject
{
    public NvidiaRerankRequestEntity {
        Objects.requireNonNull(modelId);
        Objects.requireNonNull(query);
        Objects.requireNonNull(passages);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("model", this.modelId);
        builder.startObject("query");
        builder.field("text", this.query);
        builder.endObject();
        builder.startArray("passages");
        for (String passage : this.passages) {
            builder.startObject();
            builder.field("text", passage);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

