/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.request.embeddings;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.nvidia.embeddings.NvidiaEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.nvidia.request.embeddings.NvidiaEmbeddingsRequestEntity;

public class NvidiaEmbeddingsRequest
implements Request {
    private final NvidiaEmbeddingsModel model;
    private final Truncator.TruncationResult truncationResult;
    private final Truncator truncator;
    private final InputType inputType;

    public NvidiaEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, NvidiaEmbeddingsModel model, @Nullable InputType inputType) {
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
        this.truncationResult = Objects.requireNonNull(input);
        this.inputType = inputType;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.getURI());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new NvidiaEmbeddingsRequestEntity(this.truncationResult.input(), this.model.getServiceSettings().modelId(), this.extractInputTypeToUse(), this.model.getTaskSettings().getTruncation())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.model.getSecretSettings().apiKey()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    private InputType extractInputTypeToUse() {
        if (InputType.isSpecified((InputType)this.inputType)) {
            return this.inputType;
        }
        if (InputType.isSpecified((InputType)this.model.getTaskSettings().getInputType())) {
            return this.model.getTaskSettings().getInputType();
        }
        return InputType.SEARCH;
    }

    @Override
    public URI getURI() {
        return this.model.getServiceSettings().uri();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new NvidiaEmbeddingsRequest(this.truncator, truncatedInput, this.model, this.inputType);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }
}

