/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.embeddings;

import java.util.Map;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaModel;
import org.elasticsearch.xpack.inference.services.nvidia.action.NvidiaActionVisitor;
import org.elasticsearch.xpack.inference.services.nvidia.embeddings.NvidiaEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.nvidia.embeddings.NvidiaEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class NvidiaEmbeddingsModel
extends NvidiaModel {
    public static NvidiaEmbeddingsModel of(NvidiaEmbeddingsModel model, Map<String, Object> taskSettings) {
        NvidiaEmbeddingsTaskSettings requestTaskSettings = NvidiaEmbeddingsTaskSettings.fromMap(taskSettings);
        if (requestTaskSettings.isEmpty() || requestTaskSettings.equals(model.getTaskSettings())) {
            return model;
        }
        return new NvidiaEmbeddingsModel(model, NvidiaEmbeddingsTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public NvidiaEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, NvidiaEmbeddingsServiceSettings.fromMap(serviceSettings, context), NvidiaEmbeddingsTaskSettings.fromMap(taskSettings), chunkingSettings, DefaultSecretSettings.fromMap(secrets));
    }

    public NvidiaEmbeddingsModel(NvidiaEmbeddingsModel model, NvidiaEmbeddingsServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
    }

    public NvidiaEmbeddingsModel(NvidiaEmbeddingsModel model, NvidiaEmbeddingsTaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
    }

    public NvidiaEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, NvidiaEmbeddingsServiceSettings serviceSettings, NvidiaEmbeddingsTaskSettings taskSettings, ChunkingSettings chunkingSettings, SecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets(secrets));
    }

    @Override
    public NvidiaEmbeddingsServiceSettings getServiceSettings() {
        return (NvidiaEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public NvidiaEmbeddingsTaskSettings getTaskSettings() {
        return (NvidiaEmbeddingsTaskSettings)super.getTaskSettings();
    }

    @Override
    public ExecutableAction accept(NvidiaActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

