/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.completion;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class NvidiaChatCompletionServiceSettings
extends NvidiaServiceSettings {
    public static final String NAME = "nvidia_chat_completion_service_settings";
    private static final URIBuilder DEFAULT_URI_BUILDER = new URIBuilder().setScheme("https").setHost("integrate.api.nvidia.com").setPathSegments(new String[]{"v1", "chat", "completions"});

    public static NvidiaChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return NvidiaChatCompletionServiceSettings.fromMap(map, context, commonServiceSettings -> new NvidiaChatCompletionServiceSettings(commonServiceSettings.model(), commonServiceSettings.uri(), commonServiceSettings.rateLimitSettings()));
    }

    public NvidiaChatCompletionServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    public NvidiaChatCompletionServiceSettings(String modelId, @Nullable URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        super(modelId, uri, rateLimitSettings);
    }

    @Override
    protected URI buildDefaultUri() throws URISyntaxException {
        return DEFAULT_URI_BUILDER.build();
    }

    public NvidiaChatCompletionServiceSettings(String modelId, @Nullable String url, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createOptionalUri(url), rateLimitSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NvidiaChatCompletionServiceSettings that = (NvidiaChatCompletionServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.rateLimitSettings);
    }
}

