/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia.completion;

import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponseUtils;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;

public class NvidiaChatCompletionResponseHandler
extends OpenAiUnifiedChatCompletionResponseHandler {
    private static final String NVIDIA_ERROR = "nvidia_error";
    private static final UnifiedChatCompletionErrorParserContract NVIDIA_ERROR_PARSER = UnifiedChatCompletionErrorResponseUtils.createErrorParserWithStringify("nvidia_error");

    public NvidiaChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, NVIDIA_ERROR_PARSER::parse, NVIDIA_ERROR_PARSER);
    }

    @Override
    protected RetryException buildExceptionHandlingContentTooLarge(Request request, HttpResult result) {
        return new RetryException(false, (Throwable)this.buildError("Received a content too large status code", request, result));
    }

    @Override
    public boolean isContentTooLarge(HttpResult result) {
        return NvidiaUtils.isContentTooLarge(result, "Please reduce your prompt; or completion length.");
    }
}

