/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia;

import java.lang.runtime.SwitchBootstraps;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaService;

public final class NvidiaUtils {
    public static final String HOST = "integrate.api.nvidia.com";
    public static final String VERSION_1 = "v1";
    public static final String EMBEDDINGS_PATH = "embeddings";
    public static final String CHAT_PATH = "chat";
    public static final String COMPLETIONS_PATH = "completions";
    public static final String RERANK_HOST = "ai.api.nvidia.com";
    public static final String RETRIEVAL_PATH = "retrieval";
    public static final String NVIDIA_PATH = "nvidia";
    public static final String RERANKING_PATH = "reranking";
    private static final String PASSAGE = "passage";
    private static final String QUERY = "query";
    public static final TransportVersion ML_INFERENCE_NVIDIA_ADDED = TransportVersion.fromName((String)"ml_inference_nvidia_added");

    public static String inputTypeToString(InputType inputType) {
        InputType inputType2 = inputType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INGEST", "INTERNAL_INGEST", "SEARCH", "INTERNAL_SEARCH"}, (InputType)inputType2, n)) {
            case 0, 1 -> PASSAGE;
            case 2, 3 -> QUERY;
            default -> throw new IllegalArgumentException(Strings.format((String)"Unrecognized input_type [%s], must be one of %s", (Object[])new Object[]{inputType, NvidiaService.VALID_INPUT_TYPE_VALUES}));
        };
    }

    public static boolean supportsNvidia(TransportVersion version) {
        return version.supports(ML_INFERENCE_NVIDIA_ADDED);
    }

    public static boolean isContentTooLarge(HttpResult result, String contentTooLargeMessage) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 413) {
            return true;
        }
        if (statusCode == 400) {
            ErrorResponse errorResponse = ErrorResponse.fromResponse(result);
            return errorResponse != null && errorResponse.getErrorMessage() != null && errorResponse.getErrorMessage().contains(contentTooLargeMessage);
        }
        return false;
    }

    private NvidiaUtils() {
    }
}

