/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.nvidia;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.nvidia.NvidiaUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class NvidiaServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    protected final String modelId;
    protected final URI uri;
    protected final RateLimitSettings rateLimitSettings;

    protected NvidiaServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.uri = ServiceUtils.createUri(in.readString());
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    protected NvidiaServiceSettings(String modelId, @Nullable URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = Objects.requireNonNull(modelId);
        this.uri = RequestUtils.buildUri(uri, "nvidia", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)this::buildDefaultUri));
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    protected abstract URI buildDefaultUri() throws URISyntaxException;

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return NvidiaUtils.ML_INFERENCE_NVIDIA_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return NvidiaUtils.supportsNvidia(version);
    }

    public String modelId() {
        return this.modelId;
    }

    public URI uri() {
        return this.uri;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.uri.toString());
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        builder.field("url", this.uri.toString());
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    protected static <T extends NvidiaServiceSettings> T fromMap(Map<String, Object> map, ConfigurationParseContext context, Function<NvidiaCommonServiceSettings, T> factory) {
        ValidationException validationException = new ValidationException();
        NvidiaCommonServiceSettings commonServiceSettings = NvidiaServiceSettings.extractNvidiaCommonServiceSettings(map, context, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return (T)((NvidiaServiceSettings)factory.apply(commonServiceSettings));
    }

    protected static NvidiaCommonServiceSettings extractNvidiaCommonServiceSettings(Map<String, Object> map, ConfigurationParseContext context, ValidationException validationException) {
        String model = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.extractOptionalUri(map, "url", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "nvidia", context);
        return new NvidiaCommonServiceSettings(model, uri, rateLimitSettings);
    }

    protected record NvidiaCommonServiceSettings(String model, @Nullable URI uri, RateLimitSettings rateLimitSettings) {
    }
}

