/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIService;

public class JinaAIEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "jinaai_embeddings_task_settings";
    public static final JinaAIEmbeddingsTaskSettings EMPTY_SETTINGS = new JinaAIEmbeddingsTaskSettings((InputType)null);
    static final String INPUT_TYPE = "input_type";
    static final String LATE_CHUNKING = "late_chunking";
    protected static final TransportVersion JINA_AI_CONFIGURABLE_LATE_CHUNKING = TransportVersion.fromName((String)"jina_ai_configurable_late_chunking");
    private final InputType inputType;
    private final Boolean lateChunking;

    public static JinaAIEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, JinaAIService.VALID_INPUT_TYPE_VALUES, validationException);
        Boolean lateChunking = ServiceUtils.extractOptionalBoolean(map, LATE_CHUNKING, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new JinaAIEmbeddingsTaskSettings(inputType, lateChunking);
    }

    public static JinaAIEmbeddingsTaskSettings of(JinaAIEmbeddingsTaskSettings originalSettings, JinaAIEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = JinaAIEmbeddingsTaskSettings.getValidInputType(originalSettings, requestTaskSettings);
        Boolean lateChunkingToUse = requestTaskSettings.lateChunking != null ? requestTaskSettings.lateChunking : originalSettings.lateChunking;
        return new JinaAIEmbeddingsTaskSettings(inputTypeToUse, lateChunkingToUse);
    }

    private static InputType getValidInputType(JinaAIEmbeddingsTaskSettings originalSettings, JinaAIEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    public JinaAIEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this.inputType = (InputType)in.readOptionalEnum(InputType.class);
        this.lateChunking = in.getTransportVersion().supports(JINA_AI_CONFIGURABLE_LATE_CHUNKING) ? in.readOptionalBoolean() : null;
    }

    public JinaAIEmbeddingsTaskSettings(@Nullable InputType inputType, Boolean lateChunking) {
        JinaAIEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.lateChunking = lateChunking;
    }

    public JinaAIEmbeddingsTaskSettings(@Nullable InputType inputType) {
        JinaAIEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.lateChunking = null;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (JinaAIService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.lateChunking == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.lateChunking != null) {
            builder.field(LATE_CHUNKING, this.lateChunking);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Boolean getLateChunking() {
        return this.lateChunking;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        if (out.getTransportVersion().supports(JINA_AI_CONFIGURABLE_LATE_CHUNKING)) {
            out.writeOptionalBoolean(this.lateChunking);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JinaAIEmbeddingsTaskSettings that = (JinaAIEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals(this.lateChunking, that.lateChunking);
    }

    public int hashCode() {
        return Objects.hash(this.inputType, this.lateChunking);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        JinaAIEmbeddingsTaskSettings updatedSettings = JinaAIEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return JinaAIEmbeddingsTaskSettings.of(this, updatedSettings);
    }
}

