/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq.request;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.unified.UnifiedChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.groq.completion.GroqChatCompletionModel;

class GroqUnifiedChatCompletionRequestEntity
implements ToXContentObject {
    private static final String USER_FIELD = "user";
    private final UnifiedChatCompletionRequestEntity unifiedRequestEntity;
    private final GroqChatCompletionModel model;

    GroqUnifiedChatCompletionRequestEntity(UnifiedChatInput unifiedChatInput, GroqChatCompletionModel model) {
        this.unifiedRequestEntity = new UnifiedChatCompletionRequestEntity(unifiedChatInput);
        this.model = Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.unifiedRequestEntity.toXContent(builder, UnifiedCompletionRequest.withMaxCompletionTokens((String)this.model.getServiceSettings().modelId(), (ToXContent.Params)params));
        if (!Strings.isNullOrEmpty((String)this.model.getTaskSettings().user())) {
            builder.field(USER_FIELD, this.model.getTaskSettings().user());
        }
        builder.endObject();
        return builder;
    }
}

