/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.groq.GroqRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.groq.GroqService;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GroqChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GroqRateLimitServiceSettings {
    public static final String NAME = "groq_completion_service_settings";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1000L);
    private final String modelId;
    @Nullable
    private final URI uri;
    @Nullable
    private final String organizationId;
    private final RateLimitSettings rateLimitSettings;

    public static GroqChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        String organizationId = ServiceUtils.extractOptionalString(map, "organization_id", "service_settings", validationException);
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "groq", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GroqChatCompletionServiceSettings(modelId, uri, organizationId, rateLimitSettings);
    }

    public GroqChatCompletionServiceSettings(String modelId, @Nullable URI uri, @Nullable String organizationId, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = Objects.requireNonNull(modelId);
        this.uri = uri;
        this.organizationId = organizationId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    GroqChatCompletionServiceSettings(String modelId, @Nullable String uri, @Nullable String organizationId, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createOptionalUri(uri), organizationId, rateLimitSettings);
    }

    public GroqChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.organizationId = in.readOptionalString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String organizationId() {
        return this.organizationId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.organizationId != null) {
            builder.field("organization_id", this.organizationId);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return GroqService.GROQ_INFERENCE_SERVICE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalString(this.uri != null ? this.uri.toString() : null);
        out.writeOptionalString(this.organizationId);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GroqChatCompletionServiceSettings that = (GroqChatCompletionServiceSettings)object;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.organizationId, this.rateLimitSettings);
    }
}

