/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.xpack.inference.services.elastic.authorization.AuthorizationTaskExecutor;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMPersistentStorageService;

public class CCMService {
    private static final Logger logger = LogManager.getLogger(CCMService.class);
    private final CCMPersistentStorageService ccmPersistentStorageService;
    private final Client client;

    public CCMService(CCMPersistentStorageService ccmPersistentStorageService, Client client) {
        this.ccmPersistentStorageService = Objects.requireNonNull(ccmPersistentStorageService);
        this.client = new OriginSettingClient(Objects.requireNonNull(client), "inference");
    }

    public void isEnabled(ActionListener<Boolean> listener) {
        ActionListener ccmModelListener = ActionListener.wrap(ignored -> listener.onResponse((Object)true), e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onResponse((Object)false);
                return;
            }
            listener.onFailure(e);
        });
        this.ccmPersistentStorageService.get((ActionListener<CCMModel>)ccmModelListener);
    }

    public void storeConfiguration(CCMModel model, ActionListener<Void> listener) {
        SubscribableListener.newForked(storeListener -> this.ccmPersistentStorageService.store(model, (ActionListener<Void>)storeListener)).andThen(enableAuthExecutorListener -> this.client.execute(AuthorizationTaskExecutor.Action.INSTANCE, AuthorizationTaskExecutor.Action.request(AuthorizationTaskExecutor.Message.ENABLE_MESSAGE, null), ActionListener.wrap(ack -> {
            logger.debug("Successfully enabled authorization task executor");
            enableAuthExecutorListener.onResponse(null);
        }, e -> {
            logger.atDebug().withThrowable((Throwable)e).log("Failed to enable authorization task executor");
            enableAuthExecutorListener.onFailure(e);
        }))).addListener(listener);
    }

    public void getConfiguration(ActionListener<CCMModel> listener) {
        this.ccmPersistentStorageService.get(listener);
    }

    public void disableCCM(ActionListener<Void> listener) {
        SubscribableListener.newForked(disableAuthExecutorListener -> this.client.execute(AuthorizationTaskExecutor.Action.INSTANCE, AuthorizationTaskExecutor.Action.request(AuthorizationTaskExecutor.Message.DISABLE_MESSAGE, null), ActionListener.wrap(ack -> {
            logger.debug("Successfully disabled authorization task executor");
            disableAuthExecutorListener.onResponse(null);
        }, e -> {
            logger.atDebug().withThrowable((Throwable)e).log("Failed to disable authorization task executor");
            disableAuthExecutorListener.onFailure(e);
        }))).andThen(this.ccmPersistentStorageService::delete).addListener(listener);
    }
}

