/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;

public class CCMPersistentStorageService {
    private static final Logger logger = LogManager.getLogger(CCMPersistentStorageService.class);
    public static final String CCM_DOC_ID = "ccm_config";
    private final Client client;

    public CCMPersistentStorageService(Client client) {
        this.client = new OriginSettingClient(Objects.requireNonNull(client), "inference");
    }

    public void store(CCMModel model, ActionListener<Void> listener) {
        try {
            ((IndexRequestBuilder)this.client.prepareIndex().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).setIndex(".ccm-inference")).setSource(this.createSource(model)).setId(CCM_DOC_ID).execute(listener.delegateFailureIgnoreResponseAndWrap(delegate -> delegate.onResponse(null)));
        }
        catch (Exception e) {
            logger.warn("Failed to persist CCM configuration", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private XContentBuilder createSource(CCMModel model) throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();){
            XContentBuilder xContentBuilder2 = model.toXContent(xContentBuilder, null);
            return xContentBuilder2;
        }
    }

    public void get(ActionListener<CCMModel> listener) {
        ResourceNotFoundException ccmConfigNotFound = new ResourceNotFoundException("CCM configuration not found", new Object[0]);
        ActionListener searchListener = ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getHits().length == 0) {
                listener.onFailure((Exception)((Object)ccmConfigNotFound));
                return;
            }
            assert (searchResponse.getHits().getHits().length == 1);
            listener.onResponse((Object)CCMModel.fromXContentBytes(searchResponse.getHits().getHits()[0].getSourceRef()));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onFailure((Exception)((Object)ccmConfigNotFound));
                return;
            }
            String message = "Failed to retrieve CCM configuration";
            logger.warn(message, (Throwable)e);
            listener.onFailure((Exception)new ElasticsearchException(message, (Throwable)e, new Object[0]));
        });
        this.client.prepareSearch(new String[]{".ccm-inference*"}).setSize(1).setTrackTotalHits(false).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{CCM_DOC_ID})).execute(searchListener);
    }

    public void delete(ActionListener<Void> listener) {
        DeleteByQueryRequest request = ((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest().setAbortOnVersionConflict(false)).indices(new String[]{".ccm-inference*"}).setRefresh(true)).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{CCM_DOC_ID}));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener.delegateFailureIgnoreResponseAndWrap(delegate -> delegate.onResponse(null)));
    }
}

