/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.action;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.action.ModelStrategyFactory;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMAuthenticationApplierFactory;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceActionCreator {
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    private final CCMAuthenticationApplierFactory ccmAuthenticationApplierFactory;

    public ElasticInferenceServiceActionCreator(Sender sender, ServiceComponents serviceComponents, CCMAuthenticationApplierFactory ccmAuthenticationApplierFactory) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
        this.ccmAuthenticationApplierFactory = Objects.requireNonNull(ccmAuthenticationApplierFactory);
    }

    public <T extends ElasticInferenceServiceModel> void create(T model, TraceContext traceContext, ActionListener<ExecutableAction> listener) {
        ActionListener authListener = listener.delegateFailureAndWrap((delegate, applier) -> {
            ModelStrategyFactory.Strategy<ElasticInferenceServiceModel> strategy = ModelStrategyFactory.getStrategy(model);
            RequestManager requestManager = strategy.createRequestManager(model, this.serviceComponents, traceContext, (CCMAuthenticationApplierFactory.AuthApplier)applier);
            delegate.onResponse((Object)new SenderExecutableAction(this.sender, requestManager, ActionUtils.constructFailedToSendRequestMessage(strategy.requestDescription())));
        });
        this.ccmAuthenticationApplierFactory.getAuthenticationApplier((ActionListener<CCMAuthenticationApplierFactory.AuthApplier>)authListener);
    }
}

