/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.response.CustomResponseParser;

public abstract class BaseCustomResponseParser
implements CustomResponseParser {
    @Override
    public InferenceServiceResults parse(HttpResult response) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map map = jsonParser.map();
            InferenceServiceResults inferenceServiceResults = this.transform(map);
            return inferenceServiceResults;
        }
    }

    protected abstract InferenceServiceResults transform(Map<String, Object> var1);

    static List<?> validateList(Object obj, String fieldName) {
        BaseCustomResponseParser.validateNonNull(obj, fieldName);
        if (!(obj instanceof List)) {
            throw new IllegalArgumentException(Strings.format((String)"Extracted field [%s] is an invalid type, expected a list but received [%s]", (Object[])new Object[]{fieldName, obj.getClass().getSimpleName()}));
        }
        return (List)obj;
    }

    static void validateNonNull(Object obj, String fieldName) {
        Objects.requireNonNull(obj, Strings.format((String)"Failed to parse field [%s], extracted field was null", (Object[])new Object[]{fieldName}));
    }

    static Map<String, Object> validateMap(Object obj, String fieldName) {
        BaseCustomResponseParser.validateNonNull(obj, fieldName);
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException(Strings.format((String)"Extracted field [%s] is an invalid type, expected a map but received [%s]", (Object[])new Object[]{fieldName, obj.getClass().getSimpleName()}));
        }
        Set keys = ((Map)obj).keySet();
        for (Object key : keys) {
            if (key instanceof String) continue;
            throw new IllegalStateException(Strings.format((String)"Extracted field [%s] map has an invalid key type. Expected a string but received [%s]", (Object[])new Object[]{fieldName, key.getClass().getSimpleName()}));
        }
        Map result = (Map)obj;
        return result;
    }

    static List<Float> convertToListOfFloats(Object obj, String fieldName) {
        return BaseCustomResponseParser.castList(BaseCustomResponseParser.validateList(obj, fieldName), BaseCustomResponseParser::toFloat, fieldName);
    }

    static Float toFloat(Object obj, String fieldName) {
        return Float.valueOf(BaseCustomResponseParser.toNumber(obj, fieldName).floatValue());
    }

    static List<Byte> convertToListOfBits(Object obj, String fieldName) {
        return BaseCustomResponseParser.convertToListOfBytes(obj, fieldName);
    }

    static List<Byte> convertToListOfBytes(Object obj, String fieldName) {
        return BaseCustomResponseParser.castList(BaseCustomResponseParser.validateList(obj, fieldName), BaseCustomResponseParser::toByte, fieldName);
    }

    static Byte toByte(Object obj, String fieldName) {
        short shortValue = BaseCustomResponseParser.toNumber(obj, fieldName).shortValue();
        ServiceUtils.checkByteBounds(shortValue);
        return (byte)shortValue;
    }

    private static Number toNumber(Object obj, String fieldName) {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException(Strings.format((String)"Unable to convert field [%s] of type [%s] to Number", (Object[])new Object[]{fieldName, obj.getClass().getSimpleName()}));
        }
        return (Number)obj;
    }

    static List<Integer> convertToListOfIntegers(Object obj, String fieldName) {
        return BaseCustomResponseParser.castList(BaseCustomResponseParser.validateList(obj, fieldName), BaseCustomResponseParser::toInteger, fieldName);
    }

    private static Integer toInteger(Object obj, String fieldName) {
        return BaseCustomResponseParser.toNumber(obj, fieldName).intValue();
    }

    static <T> List<T> castList(List<?> items, BiFunction<Object, String, T> converter, String fieldName) {
        BaseCustomResponseParser.validateNonNull(items, fieldName);
        ArrayList<T> resultList = new ArrayList<T>();
        for (int i = 0; i < items.size(); ++i) {
            try {
                resultList.add(converter.apply(items.get(i), fieldName));
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(Strings.format((String)"Failed to parse list entry [%d], error: %s", (Object[])new Object[]{i, e.getMessage()}), e);
            }
        }
        return resultList;
    }

    static <T> T toType(Object obj, Class<T> type, String fieldName) {
        BaseCustomResponseParser.validateNonNull(obj, fieldName);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(Strings.format((String)"Unable to convert field [%s] of type [%s] to [%s]", (Object[])new Object[]{fieldName, obj.getClass().getSimpleName(), type.getSimpleName()}));
        }
        return type.cast(obj);
    }
}

