/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.inference.common.JsonUtils;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.services.custom.request.RequestParameters;

public class RerankParameters
extends RequestParameters {
    private static final String QUERY = "query";
    private final QueryAndDocsInputs queryAndDocsInputs;

    public static RerankParameters of(QueryAndDocsInputs queryAndDocsInputs) {
        Objects.requireNonNull(queryAndDocsInputs);
        return new RerankParameters(queryAndDocsInputs);
    }

    private RerankParameters(QueryAndDocsInputs queryAndDocsInputs) {
        super(queryAndDocsInputs.getChunks());
        this.queryAndDocsInputs = queryAndDocsInputs;
    }

    @Override
    protected Map<String, String> taskTypeParameters() {
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put(QUERY, JsonUtils.toJson(this.queryAndDocsInputs.getQuery(), QUERY));
        if (this.queryAndDocsInputs.getTopN() != null) {
            additionalParameters.put(InferenceAction.Request.TOP_N.getPreferredName(), JsonUtils.toJson(this.queryAndDocsInputs.getTopN(), InferenceAction.Request.TOP_N.getPreferredName()));
        }
        if (this.queryAndDocsInputs.getReturnDocuments() != null) {
            additionalParameters.put(InferenceAction.Request.RETURN_DOCUMENTS.getPreferredName(), JsonUtils.toJson(this.queryAndDocsInputs.getReturnDocuments(), InferenceAction.Request.RETURN_DOCUMENTS.getPreferredName()));
        }
        return additionalParameters;
    }
}

