/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.contextualai.rerank.ContextualAiRerankModel;

public class ContextualAiRerankRequestEntity
implements ToXContentObject {
    private static final String MODEL_FIELD = "model";
    private static final String QUERY_FIELD = "query";
    private static final String DOCUMENTS_FIELD = "documents";
    private static final String TOP_N_FIELD = "top_n";
    private static final String INSTRUCTION_FIELD = "instruction";
    private final String query;
    private final List<String> documents;
    private final Integer topN;
    private final String instruction;
    private final ContextualAiRerankModel model;

    public ContextualAiRerankRequestEntity(String query, List<String> documents, @Nullable Integer topN, @Nullable String instruction, ContextualAiRerankModel model) {
        this.query = Objects.requireNonNull(query);
        this.documents = Objects.requireNonNull(documents);
        this.topN = topN;
        this.instruction = instruction;
        this.model = Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(QUERY_FIELD, this.query);
        builder.field(MODEL_FIELD, this.model.modelId());
        if (this.topN != null) {
            builder.field(TOP_N_FIELD, this.topN);
        } else if (this.model.getTaskSettings() != null && this.model.getTaskSettings().getTopN() != null) {
            builder.field(TOP_N_FIELD, this.model.getTaskSettings().getTopN());
        }
        if (this.instruction != null) {
            builder.field(INSTRUCTION_FIELD, this.instruction);
        }
        builder.field(DOCUMENTS_FIELD, this.documents);
        builder.endObject();
        return builder;
    }
}

