/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class CohereRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "cohere_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_N_DOCS_ONLY = "top_n";
    public static final String MAX_CHUNKS_PER_DOC = "max_chunks_per_doc";
    static final CohereRerankTaskSettings EMPTY_SETTINGS = new CohereRerankTaskSettings(null, null, null);
    private final Integer topNDocumentsOnly;
    private final Boolean returnDocuments;
    private final Integer maxChunksPerDoc;

    public static CohereRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topNDocumentsOnly = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N_DOCS_ONLY, "task_settings", validationException);
        Integer maxChunksPerDoc = ServiceUtils.extractOptionalPositiveInteger(map, MAX_CHUNKS_PER_DOC, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return CohereRerankTaskSettings.of(topNDocumentsOnly, returnDocuments, maxChunksPerDoc);
    }

    public static CohereRerankTaskSettings of(CohereRerankTaskSettings originalSettings, CohereRerankTaskSettings requestTaskSettings) {
        return new CohereRerankTaskSettings(requestTaskSettings.getTopNDocumentsOnly() != null ? requestTaskSettings.getTopNDocumentsOnly() : originalSettings.getTopNDocumentsOnly(), requestTaskSettings.getReturnDocuments() != null ? requestTaskSettings.getReturnDocuments() : originalSettings.getReturnDocuments(), requestTaskSettings.getMaxChunksPerDoc() != null ? requestTaskSettings.getMaxChunksPerDoc() : originalSettings.getMaxChunksPerDoc());
    }

    public static CohereRerankTaskSettings of(Integer topNDocumentsOnly, Boolean returnDocuments, Integer maxChunksPerDoc) {
        return new CohereRerankTaskSettings(topNDocumentsOnly, returnDocuments, maxChunksPerDoc);
    }

    public CohereRerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalInt(), in.readOptionalBoolean(), in.readOptionalInt());
    }

    public CohereRerankTaskSettings(@Nullable Integer topNDocumentsOnly, @Nullable Boolean doReturnDocuments, @Nullable Integer maxChunksPerDoc) {
        this.topNDocumentsOnly = topNDocumentsOnly;
        this.returnDocuments = doReturnDocuments;
        this.maxChunksPerDoc = maxChunksPerDoc;
    }

    public boolean isEmpty() {
        return this.topNDocumentsOnly == null && this.returnDocuments == null && this.maxChunksPerDoc == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topNDocumentsOnly != null) {
            builder.field(TOP_N_DOCS_ONLY, this.topNDocumentsOnly);
        }
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        if (this.maxChunksPerDoc != null) {
            builder.field(MAX_CHUNKS_PER_DOC, this.maxChunksPerDoc);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.topNDocumentsOnly);
        out.writeOptionalBoolean(this.returnDocuments);
        out.writeOptionalInt(this.maxChunksPerDoc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereRerankTaskSettings that = (CohereRerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topNDocumentsOnly, that.topNDocumentsOnly) && Objects.equals(this.maxChunksPerDoc, that.maxChunksPerDoc);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topNDocumentsOnly, this.maxChunksPerDoc);
    }

    public Boolean getDoesReturnDocuments() {
        return this.returnDocuments;
    }

    public Integer getTopNDocumentsOnly() {
        return this.topNDocumentsOnly;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public Integer getMaxChunksPerDoc() {
        return this.maxChunksPerDoc;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        CohereRerankTaskSettings updatedSettings = CohereRerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return CohereRerankTaskSettings.of(this, updatedSettings);
    }
}

